/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Arrays;
import java.util.Iterator;

public class TypeAnnotationPosition {
    public static final List<TypePathEntry> emptyPath = List.nil();
    public final TargetType type;
    public List<TypePathEntry> location;
    public final int pos;
    public boolean isValidOffset = false;
    public int offset = -1;
    public int[] lvarOffset = null;
    public int[] lvarLength = null;
    public int[] lvarIndex = null;
    public final int bound_index;
    public final int parameter_index;
    public int type_index;
    public int exception_index = Integer.MIN_VALUE;
    public final JCTree.JCLambda onLambda;
    public static final TypeAnnotationPosition unknown = new TypeAnnotationPosition(TargetType.UNKNOWN, -1, Integer.MIN_VALUE, null, Integer.MIN_VALUE, Integer.MIN_VALUE, emptyPath);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append((Object)this.type);
        switch (this.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                sb.append(", offset = ");
                sb.append(this.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                if (this.lvarOffset == null) {
                    sb.append(", lvarOffset is null!");
                    break;
                }
                sb.append(", {");
                for (int i = 0; i < this.lvarOffset.length; ++i) {
                    if (i != 0) {
                        sb.append("; ");
                    }
                    sb.append("start_pc = ");
                    sb.append(this.lvarOffset[i]);
                    sb.append(", length = ");
                    sb.append(this.lvarLength[i]);
                    sb.append(", index = ");
                    sb.append(this.lvarIndex[i]);
                }
                sb.append("}");
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                sb.append(", bound_index = ");
                sb.append(this.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case THROWS: {
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case EXCEPTION_PARAMETER: {
                sb.append(", exception_index = ");
                sb.append(this.exception_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                sb.append(", param_index = ");
                sb.append(this.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                sb.append(", offset = ");
                sb.append(this.offset);
                sb.append(", type_index = ");
                sb.append(this.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                sb.append(", position UNKNOWN!");
                break;
            }
            default: {
                Assert.error("Unknown target type: " + (Object)((Object)this.type));
            }
        }
        if (!this.location.isEmpty()) {
            sb.append(", location = (");
            sb.append(this.location);
            sb.append(")");
        }
        sb.append(", pos = ");
        sb.append(this.pos);
        if (this.onLambda != null) {
            sb.append(", onLambda hash = ");
            sb.append(this.onLambda.hashCode());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean emitToClassfile() {
        return !this.type.isLocal() || this.isValidOffset;
    }

    public boolean matchesPos(int pos) {
        return this.pos == pos;
    }

    public void updatePosOffset(int to) {
        this.offset = to;
        this.lvarOffset = new int[]{to};
        this.isValidOffset = true;
    }

    public static List<TypePathEntry> getTypePathFromBinary(java.util.List<Integer> list) {
        ListBuffer<TypePathEntry> loc = new ListBuffer<TypePathEntry>();
        Iterator<Integer> iter = list.iterator();
        while (iter.hasNext()) {
            Integer fst = iter.next();
            Assert.check(iter.hasNext(), "Could not decode type path: " + list);
            Integer snd = iter.next();
            loc = loc.append(TypePathEntry.fromBinary(fst, snd));
        }
        return loc.toList();
    }

    public static List<Integer> getBinaryFromTypePath(java.util.List<TypePathEntry> locs) {
        ListBuffer<Object> loc = new ListBuffer<Integer>();
        for (TypePathEntry tpe : locs) {
            loc = loc.append(tpe.tag.tag);
            loc = loc.append(tpe.arg);
        }
        return loc.toList();
    }

    private TypeAnnotationPosition(TargetType ttype, int pos, int parameter_index, JCTree.JCLambda onLambda, int type_index, int bound_index, List<TypePathEntry> location) {
        Assert.checkNonNull(location);
        this.type = ttype;
        this.pos = pos;
        this.parameter_index = parameter_index;
        this.onLambda = onLambda;
        this.type_index = type_index;
        this.bound_index = bound_index;
        this.location = location;
    }

    public static TypeAnnotationPosition copy(TypeAnnotationPosition tapos) {
        TypeAnnotationPosition res = new TypeAnnotationPosition(tapos.type, tapos.pos, tapos.parameter_index, tapos.onLambda, tapos.type_index, tapos.bound_index, List.from(tapos.location));
        res.isValidOffset = tapos.isValidOffset;
        res.exception_index = tapos.exception_index;
        if (tapos.lvarIndex != null) {
            res.lvarIndex = Arrays.copyOf(tapos.lvarIndex, tapos.lvarIndex.length);
        }
        if (tapos.lvarLength != null) {
            res.lvarLength = Arrays.copyOf(tapos.lvarLength, tapos.lvarLength.length);
        }
        if (tapos.lvarOffset != null) {
            res.lvarOffset = Arrays.copyOf(tapos.lvarOffset, tapos.lvarOffset.length);
        }
        res.offset = tapos.offset;
        return res;
    }

    public static TypeAnnotationPosition methodReturn(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_RETURN, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodReturn(List<TypePathEntry> location) {
        return TypeAnnotationPosition.methodReturn(location, null, -1);
    }

    public static TypeAnnotationPosition methodReturn(int pos) {
        return TypeAnnotationPosition.methodReturn(emptyPath, null, pos);
    }

    public static TypeAnnotationPosition methodReceiver(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_RECEIVER, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodReceiver(List<TypePathEntry> location) {
        return TypeAnnotationPosition.methodReceiver(location, null, -1);
    }

    public static TypeAnnotationPosition methodReceiver(int pos) {
        return TypeAnnotationPosition.methodReceiver(emptyPath, null, pos);
    }

    public static TypeAnnotationPosition methodParameter(List<TypePathEntry> location, JCTree.JCLambda onLambda, int parameter_index, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_FORMAL_PARAMETER, pos, parameter_index, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodParameter(JCTree.JCLambda onLambda, int parameter_index, int pos) {
        return TypeAnnotationPosition.methodParameter(emptyPath, onLambda, parameter_index, pos);
    }

    public static TypeAnnotationPosition methodParameter(int parameter_index, int pos) {
        return TypeAnnotationPosition.methodParameter(null, parameter_index, pos);
    }

    public static TypeAnnotationPosition methodParameter(List<TypePathEntry> location, int parameter_index) {
        return TypeAnnotationPosition.methodParameter(location, null, parameter_index, -1);
    }

    public static TypeAnnotationPosition methodRef(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_REFERENCE, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodRef(List<TypePathEntry> location) {
        return TypeAnnotationPosition.methodRef(location, null, -1);
    }

    public static TypeAnnotationPosition constructorRef(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_REFERENCE, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition constructorRef(List<TypePathEntry> location) {
        return TypeAnnotationPosition.constructorRef(location, null, -1);
    }

    public static TypeAnnotationPosition field(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.FIELD, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition field(List<TypePathEntry> location) {
        return TypeAnnotationPosition.field(location, null, -1);
    }

    public static TypeAnnotationPosition field(int pos) {
        return TypeAnnotationPosition.field(emptyPath, null, pos);
    }

    public static TypeAnnotationPosition localVariable(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.LOCAL_VARIABLE, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition localVariable(JCTree.JCLambda onLambda, int pos) {
        return TypeAnnotationPosition.localVariable(emptyPath, onLambda, pos);
    }

    public static TypeAnnotationPosition localVariable(List<TypePathEntry> location) {
        return TypeAnnotationPosition.localVariable(location, null, -1);
    }

    public static TypeAnnotationPosition exceptionParameter(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.EXCEPTION_PARAMETER, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition exceptionParameter(JCTree.JCLambda onLambda, int pos) {
        return TypeAnnotationPosition.exceptionParameter(emptyPath, onLambda, pos);
    }

    public static TypeAnnotationPosition exceptionParameter(List<TypePathEntry> location) {
        return TypeAnnotationPosition.exceptionParameter(location, null, -1);
    }

    public static TypeAnnotationPosition resourceVariable(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.RESOURCE_VARIABLE, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition resourceVariable(JCTree.JCLambda onLambda, int pos) {
        return TypeAnnotationPosition.resourceVariable(emptyPath, onLambda, pos);
    }

    public static TypeAnnotationPosition resourceVariable(List<TypePathEntry> location) {
        return TypeAnnotationPosition.resourceVariable(location, null, -1);
    }

    public static TypeAnnotationPosition newObj(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.NEW, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition newObj(int pos) {
        return TypeAnnotationPosition.newObj(emptyPath, null, pos);
    }

    public static TypeAnnotationPosition newObj(List<TypePathEntry> location) {
        return TypeAnnotationPosition.newObj(location, null, -1);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CLASS_EXTENDS, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return TypeAnnotationPosition.classExtends(location, onLambda, -1, pos);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.classExtends(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition classExtends(int type_index, int pos) {
        return TypeAnnotationPosition.classExtends(emptyPath, null, type_index, pos);
    }

    public static TypeAnnotationPosition classExtends(int pos) {
        return TypeAnnotationPosition.classExtends(-1, pos);
    }

    public static TypeAnnotationPosition instanceOf(List<TypePathEntry> location, JCTree.JCLambda onLambda, int pos) {
        return new TypeAnnotationPosition(TargetType.INSTANCEOF, pos, Integer.MIN_VALUE, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition instanceOf(List<TypePathEntry> location) {
        return TypeAnnotationPosition.instanceOf(location, null, -1);
    }

    public static TypeAnnotationPosition typeCast(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CAST, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition typeCast(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.typeCast(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition methodInvocationTypeArg(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodInvocationTypeArg(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.methodInvocationTypeArg(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition constructorInvocationTypeArg(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition constructorInvocationTypeArg(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.constructorInvocationTypeArg(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition typeParameter(List<TypePathEntry> location, JCTree.JCLambda onLambda, int parameter_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CLASS_TYPE_PARAMETER, pos, parameter_index, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition typeParameter(List<TypePathEntry> location, int parameter_index) {
        return TypeAnnotationPosition.typeParameter(location, null, parameter_index, -1);
    }

    public static TypeAnnotationPosition methodTypeParameter(List<TypePathEntry> location, JCTree.JCLambda onLambda, int parameter_index, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_TYPE_PARAMETER, pos, parameter_index, onLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodTypeParameter(List<TypePathEntry> location, int parameter_index) {
        return TypeAnnotationPosition.methodTypeParameter(location, null, parameter_index, -1);
    }

    public static TypeAnnotationPosition methodThrows(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.THROWS, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodThrows(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.methodThrows(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition methodRefTypeArg(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition methodRefTypeArg(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.methodRefTypeArg(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition constructorRefTypeArg(List<TypePathEntry> location, JCTree.JCLambda onLambda, int type_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, pos, Integer.MIN_VALUE, onLambda, type_index, Integer.MIN_VALUE, location);
    }

    public static TypeAnnotationPosition constructorRefTypeArg(List<TypePathEntry> location, int type_index) {
        return TypeAnnotationPosition.constructorRefTypeArg(location, null, type_index, -1);
    }

    public static TypeAnnotationPosition typeParameterBound(List<TypePathEntry> location, JCTree.JCLambda onLambda, int parameter_index, int bound_index, int pos) {
        return new TypeAnnotationPosition(TargetType.CLASS_TYPE_PARAMETER_BOUND, pos, parameter_index, onLambda, Integer.MIN_VALUE, bound_index, location);
    }

    public static TypeAnnotationPosition typeParameterBound(List<TypePathEntry> location, int parameter_index, int bound_index) {
        return TypeAnnotationPosition.typeParameterBound(location, null, parameter_index, bound_index, -1);
    }

    public static TypeAnnotationPosition methodTypeParameterBound(List<TypePathEntry> location, JCTree.JCLambda onLambda, int parameter_index, int bound_index, int pos) {
        return new TypeAnnotationPosition(TargetType.METHOD_TYPE_PARAMETER_BOUND, pos, parameter_index, onLambda, Integer.MIN_VALUE, bound_index, location);
    }

    public static TypeAnnotationPosition methodTypeParameterBound(List<TypePathEntry> location, int parameter_index, int bound_index) {
        return TypeAnnotationPosition.methodTypeParameterBound(location, null, parameter_index, bound_index, -1);
    }

    public static class TypePathEntry {
        public static final int bytesPerEntry = 2;
        public final TypePathEntryKind tag;
        public final int arg;
        public static final TypePathEntry ARRAY = new TypePathEntry(TypePathEntryKind.ARRAY);
        public static final TypePathEntry INNER_TYPE = new TypePathEntry(TypePathEntryKind.INNER_TYPE);
        public static final TypePathEntry WILDCARD = new TypePathEntry(TypePathEntryKind.WILDCARD);

        private TypePathEntry(TypePathEntryKind tag) {
            Assert.check(tag == TypePathEntryKind.ARRAY || tag == TypePathEntryKind.INNER_TYPE || tag == TypePathEntryKind.WILDCARD, "Invalid TypePathEntryKind: " + (Object)((Object)tag));
            this.tag = tag;
            this.arg = 0;
        }

        public TypePathEntry(TypePathEntryKind tag, int arg) {
            Assert.check(tag == TypePathEntryKind.TYPE_ARGUMENT, "Invalid TypePathEntryKind: " + (Object)((Object)tag));
            this.tag = tag;
            this.arg = arg;
        }

        public static TypePathEntry fromBinary(int tag, int arg) {
            Assert.check(arg == 0 || tag == TypePathEntryKind.TYPE_ARGUMENT.tag, "Invalid TypePathEntry tag/arg: " + tag + "/" + arg);
            switch (tag) {
                case 0: {
                    return ARRAY;
                }
                case 1: {
                    return INNER_TYPE;
                }
                case 2: {
                    return WILDCARD;
                }
                case 3: {
                    return new TypePathEntry(TypePathEntryKind.TYPE_ARGUMENT, arg);
                }
            }
            Assert.error("Invalid TypePathEntryKind tag: " + tag);
            return null;
        }

        public String toString() {
            return this.tag.toString() + (this.tag == TypePathEntryKind.TYPE_ARGUMENT ? "(" + this.arg + ")" : "");
        }

        public boolean equals(Object other) {
            if (!(other instanceof TypePathEntry)) {
                return false;
            }
            TypePathEntry tpe = (TypePathEntry)other;
            return this.tag == tpe.tag && this.arg == tpe.arg;
        }

        public int hashCode() {
            return this.tag.hashCode() * 17 + this.arg;
        }
    }

    public static enum TypePathEntryKind {
        ARRAY(0),
        INNER_TYPE(1),
        WILDCARD(2),
        TYPE_ARGUMENT(3);

        public final int tag;

        private TypePathEntryKind(int tag) {
            this.tag = tag;
        }
    }
}

