/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.SourceVersion;

public enum Source {
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK1_5("1.5"),
    JDK1_6("1.6"),
    JDK1_7("1.7"),
    JDK1_8("1.8"),
    JDK1_9("1.9");

    private static final Context.Key<Source> sourceKey;
    public final String name;
    private static final Map<String, Source> tab;
    public static final Source DEFAULT;

    public static Source instance(Context context) {
        Source instance = context.get(sourceKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String sourceString = options.get(Option.SOURCE);
            if (sourceString != null) {
                instance = Source.lookup(sourceString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(sourceKey, instance);
        }
        return instance;
    }

    private Source(String name) {
        this.name = name;
    }

    public static Source lookup(String name) {
        return tab.get(name);
    }

    public Target requiredTarget() {
        if (this.compareTo(JDK1_7) >= 0) {
            return Target.JDK1_7;
        }
        if (this.compareTo(JDK1_9) >= 0) {
            return Target.JDK1_9;
        }
        if (this.compareTo(JDK1_8) >= 0) {
            return Target.JDK1_8;
        }
        if (this.compareTo(JDK1_7) >= 0) {
            return Target.JDK1_7;
        }
        if (this.compareTo(JDK1_6) >= 0) {
            return Target.JDK1_6;
        }
        if (this.compareTo(JDK1_5) >= 0) {
            return Target.JDK1_5;
        }
        if (this.compareTo(JDK1_4) >= 0) {
            return Target.JDK1_4;
        }
        return Target.JDK1_1;
    }

    public boolean allowEncodingErrors() {
        return this.compareTo(JDK1_6) < 0;
    }

    public boolean allowAsserts() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean allowCovariantReturns() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowGenerics() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowDiamond() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowMulticatch() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowImprovedRethrowAnalysis() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowImprovedCatchAnalysis() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowEnums() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowForeach() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowStaticImport() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowBoxing() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowVarargs() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowAnnotations() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowHexFloats() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowAnonOuterThis() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean addBridges() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean enforceMandatoryWarnings() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowTryWithResources() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowBinaryLiterals() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowUnderscoresInLiterals() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowStringsInSwitch() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowSimplifiedVarargs() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowObjectToPrimitiveCast() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowPoly() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowLambda() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowMethodReferences() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowDefaultMethods() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowStaticInterfaceMethods() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowStrictMethodClashCheck() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowEffectivelyFinalInInnerClasses() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowTypeAnnotations() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowRepeatedAnnotations() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowIntersectionTypesInCast() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowGraphInference() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowStructuralMostSpecific() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public static SourceVersion toSourceVersion(Source source) {
        switch (source) {
            case JDK1_2: {
                return SourceVersion.RELEASE_2;
            }
            case JDK1_3: {
                return SourceVersion.RELEASE_3;
            }
            case JDK1_4: {
                return SourceVersion.RELEASE_4;
            }
            case JDK1_5: {
                return SourceVersion.RELEASE_5;
            }
            case JDK1_6: {
                return SourceVersion.RELEASE_6;
            }
            case JDK1_7: {
                return SourceVersion.RELEASE_7;
            }
            case JDK1_8: {
                return SourceVersion.RELEASE_8;
            }
            case JDK1_9: {
                return SourceVersion.RELEASE_9;
            }
        }
        return null;
    }

    static {
        sourceKey = new Context.Key();
        tab = new HashMap<String, Source>();
        for (Source s : Source.values()) {
            tab.put(s.name, s);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        tab.put("9", JDK1_9);
        DEFAULT = JDK1_8;
    }
}

