/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ExecutionVisitor
extends EmptyVisitor {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame frame = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg = null;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown OperandStack stack() {
        return this.frame.getStack();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariables locals() {
        return this.frame.getLocals();
    }

    public void setConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame f) {
        this.frame = f;
    }

    @Override
    public void visitAALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AALOAD o) {
        this.stack().pop();
        Type t = this.stack().pop();
        if (t == Type.NULL) {
            this.stack().push(Type.NULL);
        } else {
            ArrayType at = (ArrayType)t;
            this.stack().push(at.getElementType());
        }
    }

    @Override
    public void visitAASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitACONST_NULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ACONST_NULL o) {
        this.stack().push(Type.NULL);
    }

    @Override
    public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ALOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ANEWARRAY o) {
        this.stack().pop();
        this.stack().push(new ArrayType(o.getType(this.cpg), 1));
    }

    @Override
    public void visitARETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ARETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitARRAYLENGTH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ARRAYLENGTH o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ASTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitATHROW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ATHROW o) {
        Type t = this.stack().pop();
        this.stack().clear();
        if (t.equals(Type.NULL)) {
            this.stack().push(Type.getType("Ljava/lang/NullPointerException;"));
        } else {
            this.stack().push(t);
        }
    }

    @Override
    public void visitBALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitBASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitBIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BIPUSH o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitCALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitCASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CHECKCAST o) {
        this.stack().pop();
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitD2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitD2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitD2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitDADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitDCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitDCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitDCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCONST o) {
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DLOAD o) {
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DNEG o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitDSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDUP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP o) {
        Type t = this.stack().pop();
        this.stack().push(t);
        this.stack().push(t);
    }

    @Override
    public void visitDUP_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP_X1 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        this.stack().push(w1);
        this.stack().push(w2);
        this.stack().push(w1);
    }

    @Override
    public void visitDUP_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP_X2 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        if (w2.getSize() == 2) {
            this.stack().push(w1);
            this.stack().push(w2);
            this.stack().push(w1);
        } else {
            Type w3 = this.stack().pop();
            this.stack().push(w1);
            this.stack().push(w3);
            this.stack().push(w2);
            this.stack().push(w1);
        }
    }

    @Override
    public void visitDUP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            this.stack().push(t);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2_X1 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(v);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2_X2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            if (u.getSize() == 2) {
                this.stack().push(t);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type v = this.stack().pop();
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            if (v.getSize() == 2) {
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type w = this.stack().pop();
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(w);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        }
    }

    @Override
    public void visitF2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitF2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitF2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitFADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitFCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitFCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitFCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCONST o) {
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FLOAD o) {
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FNEG o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitFSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitGETFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETFIELD o) {
        this.stack().pop();
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETSTATIC o) {
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGOTO(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GOTO o) {
    }

    @Override
    public void visitGOTO_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GOTO_W o) {
    }

    @Override
    public void visitI2B(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2B o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitI2C(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2C o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitI2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitI2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitI2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitI2S(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2S o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitICONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ICONST o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIF_ACMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ACMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ACMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ACMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPGE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPGT o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPLE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPLT o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIFEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFEQ o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFGE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFGT o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFLE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFLT o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNONNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNONNULL o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNULL o) {
        this.stack().pop();
    }

    @Override
    public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IINC o) {
    }

    @Override
    public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ILOAD o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INEG o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INSTANCEOF o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEDYNAMIC o) {
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEINTERFACE o) {
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESPECIAL o) {
        if (o.getMethodName(this.cpg).equals("<init>")) {
            UninitializedObjectType t = (UninitializedObjectType)this.stack().peek(o.getArgumentTypes(this.cpg).length);
            if (t == Frame.getThis()) {
                Frame.setThis(null);
            }
            this.stack().initializeObject(t);
            this.locals().initializeObject(t);
        }
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESTATIC o) {
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEVIRTUAL o) {
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitIOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitISHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitISHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitISUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitJSR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JSR o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitJSR_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JSR_W o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitL2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitL2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitL2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitLADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitLCMP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LCMP o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitLCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LCONST o) {
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
        if (c instanceof ConstantClass) {
            this.stack().push(Type.CLASS);
        }
    }

    public void visitLDC_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
        if (c instanceof ConstantClass) {
            this.stack().push(Type.CLASS);
        }
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantLong) {
            this.stack().push(Type.LONG);
        }
        if (c instanceof ConstantDouble) {
            this.stack().push(Type.DOUBLE);
        }
    }

    @Override
    public void visitLDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LLOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitLMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LNEG o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LOOKUPSWITCH o) {
        this.stack().pop();
    }

    @Override
    public void visitLOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitLSHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitLSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitMONITORENTER(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MONITORENTER o) {
        this.stack().pop();
    }

    @Override
    public void visitMONITOREXIT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MONITOREXIT o) {
        this.stack().pop();
    }

    @Override
    public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MULTIANEWARRAY o) {
        for (int i = 0; i < o.getDimensions(); ++i) {
            this.stack().pop();
        }
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEW o) {
        this.stack().push(new UninitializedObjectType((ObjectType)o.getType(this.cpg)));
    }

    @Override
    public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEWARRAY o) {
        this.stack().pop();
        this.stack().push(o.getType());
    }

    @Override
    public void visitNOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NOP o) {
    }

    @Override
    public void visitPOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown POP o) {
        this.stack().pop();
    }

    @Override
    public void visitPOP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown POP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 1) {
            this.stack().pop();
        }
    }

    @Override
    public void visitPUTFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTFIELD o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTSTATIC o) {
        this.stack().pop();
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RET o) {
    }

    @Override
    public void visitRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RETURN o) {
    }

    @Override
    public void visitSALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitSASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitSIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SIPUSH o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitSWAP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SWAP o) {
        Type t = this.stack().pop();
        Type u = this.stack().pop();
        this.stack().push(t);
        this.stack().push(u);
    }

    @Override
    public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown TABLESWITCH o) {
        this.stack().pop();
    }
}

