/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.StringTokenizer;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.Type;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        super(opcode, index);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        Constant c = cp.getConstant(super.getIndex());
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Const.getOpcodeName(super.getOpcode()) + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int consumeStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        int sum = super.getOpcode() == 184 || super.getOpcode() == 186 ? 0 : 1;
        String signature = this.getSignature(cpg);
        return sum += Type.getArgumentTypesSize(signature);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int produceStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        return Type.getReturnTypeSize(signature);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        String className = cp.getConstantString(cmr.getClassIndex(), (byte)7);
        return className.replace('/', '.');
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getMethodName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }
}

