/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ExceptionTable
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exception_index_table;

    public ExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exception_index_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    ExceptionTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exception_index_table = new int[number_of_exceptions];
        for (int i = 0; i < number_of_exceptions; ++i) {
            this.exception_index_table[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.exception_index_table.length);
        for (int index : this.exception_index_table) {
            file.writeShort(index);
        }
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberOfExceptions() {
        return this.exception_index_table == null ? 0 : this.exception_index_table.length;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionNames() {
        String[] names = new String[this.exception_index_table.length];
        for (int i = 0; i < this.exception_index_table.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public final void setExceptionIndexTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exception_index_table) {
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        for (int i = 0; i < this.exception_index_table.length; ++i) {
            String str = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i >= this.exception_index_table.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exception_index_table != null) {
            c.exception_index_table = new int[this.exception_index_table.length];
            System.arraycopy(this.exception_index_table, 0, c.exception_index_table, 0, this.exception_index_table.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

