/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConstantFloat
extends Constant
implements ConstantObject {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float bytes;

    public ConstantFloat(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float bytes) {
        super((byte)4);
        this.bytes = bytes;
    }

    public ConstantFloat(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantFloat c) {
        this(c.getBytes());
    }

    ConstantFloat(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readFloat());
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantFloat(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeFloat(this.bytes);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float getBytes() {
        return this.bytes;
    }

    public final void setBytes(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float bytes) {
        this.bytes = bytes;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object getConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return new Float(this.bytes);
    }
}

