/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class AnnotationEntry
implements Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type_index;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValuePair> element_value_pairs;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry read(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(input.readUnsignedShort(), constant_pool, isRuntimeVisible);
        int num_element_value_pairs = input.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(input.readUnsignedShort(), ElementValue.readElementValue(input, constant_pool), constant_pool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTypeIndex() {
        return this.type_index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitAnnotationEntry(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumElementValuePairs() {
        return this.element_value_pairs.size();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValuePair @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeShort(this.type_index);
        dos.writeShort(this.element_value_pairs.size());
        for (ElementValuePair envp : this.element_value_pairs) {
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValuePair elementNameValuePair) {
        this.element_value_pairs.add(elementNameValuePair);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append("@");
        result.append(this.getAnnotationType());
        ElementValuePair[] evPairs = this.getElementValuePairs();
        if (evPairs.length > 0) {
            result.append("(");
            for (ElementValuePair element : evPairs) {
                result.append(element.toShortString());
            }
            result.append(")");
        }
        return result.toString();
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return this.toShortString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] createAnnotationEntries(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof Annotations)) continue;
            Annotations runtimeAnnotations = (Annotations)attribute;
            Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getAnnotationEntries());
        }
        return accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
    }
}

