/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.mavenplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.checkerframework.mavenplugin.CommandLineExceutor;
import org.checkerframework.mavenplugin.JavacErrorMessagesParser;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenIOExecutor
implements CommandLineExceutor {
    private final String pathToExecutable;

    public MavenIOExecutor(String pathToExecutable) {
        this.pathToExecutable = pathToExecutable;
    }

    @Override
    public void executeCommandLine(Commandline cl, Log log, boolean failOnError) throws MojoExecutionException, MojoFailureException {
        List<CompilerError> messages;
        int exitCode;
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        log.debug((CharSequence)("command line: " + Arrays.toString(cl.getCommandline())));
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute the Checker Framework, executable: " + this.pathToExecutable + ", command line: " + Arrays.toString(cl.getCommandline()), (Exception)((Object)e));
        }
        try {
            messages = JavacErrorMessagesParser.parseMessages(err.getOutput());
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unable to parse messages.", (Exception)e);
        }
        if (exitCode != 0 && messages.isEmpty()) {
            throw new MojoExecutionException("Exit code from the compiler was not zero (" + exitCode + "), but no messages reported. Error stream content: " + err.getOutput() + " command line: " + Arrays.toString(cl.getCommandline()));
        }
        if (messages.isEmpty()) {
            log.info((CharSequence)"No errors found by the processor(s).");
        } else {
            if (failOnError) {
                ArrayList<CompilerError> warnings = new ArrayList<CompilerError>();
                ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
                for (CompilerError message : messages) {
                    if (message.isError()) {
                        errors.add(message);
                        continue;
                    }
                    warnings.add(message);
                }
                if (!warnings.isEmpty()) {
                    MavenIOExecutor.logErrors(warnings, "warning", true, log);
                }
                MavenIOExecutor.logErrors(errors, "error", false, log);
                throw new MojoFailureException(null, "Errors found by the processor(s)", CompilationFailureException.longMessage(errors));
            }
            log.info((CharSequence)"Run with debug logging in order to view the compiler command line");
            for (CompilerError compilerError : messages) {
                log.warn((CharSequence)compilerError.toString());
            }
        }
    }

    private static final void logErrors(List<CompilerError> errors, String label, boolean warn, Log log) {
        log.info((CharSequence)"-------------------------------------------------------------");
        log.warn((CharSequence)("CHECKER FRAMEWORK " + label.toUpperCase() + ": "));
        log.info((CharSequence)"-------------------------------------------------------------");
        for (CompilerError error : errors) {
            String msg = error.toString().trim();
            if (warn) {
                log.warn((CharSequence)msg);
                continue;
            }
            log.error((CharSequence)msg);
        }
        String labelLc = label.toLowerCase() + (errors.size() == 1 ? "" : "s");
        log.info((CharSequence)(errors.size() + " " + labelLc));
        log.info((CharSequence)"-------------------------------------------------------------");
    }
}

