/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.checkerframework.mavenplugin.CommandLineExceutor;
import org.checkerframework.mavenplugin.JavacIOExecutor;
import org.checkerframework.mavenplugin.MavenIOExecutor;
import org.checkerframework.mavenplugin.PathUtils;
import org.checkerframework.mavenplugin.PluginUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckersMojo
extends AbstractMojo {
    private List<String> processors = new ArrayList<String>();
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private boolean failOnError;
    private String executable;
    private String checkerFrameworkVersion;
    private String javaParams;
    private String javacParams;
    private boolean skip;
    private boolean procOnly;
    private boolean useJavacOutput;
    private String outputDirectory;
    private List<String> compileSourceRoots;
    private MavenSession session;
    private MavenProject project;
    private ToolchainManager toolchainManager;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private List<?> remoteArtifactRepositories;
    private List<?> classpathElements;
    private File checkerJar;
    private File javacJar;
    private File jdkJar;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String processor;
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Execution is skipped");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            log.info((CharSequence)"Execution is skipped for project with packaging 'pom'");
            return;
        }
        log.info((CharSequence)("Running Checker Framework version: " + this.checkerFrameworkVersion));
        String string = processor = this.processors.size() > 0 ? StringUtils.join(this.processors.iterator(), (String)",") : null;
        if (this.processors.size() == 0) {
            log.warn((CharSequence)"No checkers have been specified.");
        } else {
            log.info((CharSequence)("Running processor(s): " + processor));
        }
        List<String> sources = PathUtils.scanForSources(this.compileSourceRoots, this.includes, this.excludes);
        if (sources.size() == 0) {
            log.info((CharSequence)"No source files found.");
            return;
        }
        this.locateArtifacts();
        Commandline cl = new Commandline();
        if (StringUtils.isEmpty((String)this.executable)) {
            this.executable = "java";
        }
        String executablePath = PathUtils.getExecutablePath(this.executable, this.toolchainManager, this.session);
        cl.setExecutable(executablePath);
        String classpath = this.checkerJar.getAbsolutePath() + File.pathSeparator + StringUtils.join(this.classpathElements.iterator(), (String)File.pathSeparator);
        File srcFofn = null;
        File cpFofn = null;
        try {
            srcFofn = PluginUtil.writeTmpSrcFofn("CFPlugin-maven-src", true, PluginUtil.toFiles(sources));
            cpFofn = PluginUtil.writeTmpCpFile("CFPlugin-maven-cp", true, classpath);
        }
        catch (IOException e) {
            if (srcFofn != null && srcFofn.exists()) {
                srcFofn.delete();
            }
            if (cpFofn != null && cpFofn.exists()) {
                cpFofn.delete();
            }
            throw new MojoExecutionException("Exception trying to write command file fofn!", (Exception)e);
        }
        File outputDirFile = new File(this.outputDirectory);
        if (!(this.procOnly || outputDirFile.exists() || outputDirFile.mkdirs())) {
            throw new MojoExecutionException("Could not create output directory: " + outputDirFile.getAbsolutePath());
        }
        Map<PluginUtil.CheckerProp, Object> props = this.makeProps();
        List<String> arguments = PluginUtil.getCmdArgsOnly(this.javacJar, this.jdkJar, srcFofn, processor, this.checkerJar.getAbsolutePath(), null, cpFofn, null, props, null, this.procOnly, this.outputDirectory);
        cl.addArguments(arguments.toArray(new String[arguments.size()]));
        this.createCommandLineExecutor().executeCommandLine(cl, log, this.failOnError);
        srcFofn.delete();
        cpFofn.delete();
    }

    private Map<PluginUtil.CheckerProp, Object> makeProps() {
        String sourcePath = StringUtils.join(this.compileSourceRoots.iterator(), (String)File.pathSeparator);
        ArrayList<String> miscOptions = new ArrayList<String>();
        miscOptions.add("-sourcepath");
        miscOptions.add(sourcePath);
        if (!StringUtils.isEmpty((String)this.javaParams)) {
            miscOptions.addAll(PluginUtil.toJavaOpts(Arrays.asList(this.javaParams.split(" "))));
        }
        if (!StringUtils.isEmpty((String)this.javacParams)) {
            miscOptions.addAll(Arrays.asList(this.javacParams.split(" ")));
        }
        HashMap<PluginUtil.CheckerProp, Object> props = new HashMap<PluginUtil.CheckerProp, Object>();
        props.put(PluginUtil.CheckerProp.MISC_COMPILER, miscOptions);
        return props;
    }

    private final void locateArtifacts() throws MojoExecutionException {
        this.checkerJar = PathUtils.getFrameworkJar("checker", this.checkerFrameworkVersion, this.artifactFactory, this.artifactResolver, this.remoteArtifactRepositories, this.localRepository);
        this.javacJar = PathUtils.getFrameworkJar("compiler", this.checkerFrameworkVersion, this.artifactFactory, this.artifactResolver, this.remoteArtifactRepositories, this.localRepository);
        String jdkVersionStr = PluginUtil.getJdkJarPrefix();
        this.jdkJar = PathUtils.getFrameworkJar(jdkVersionStr, this.checkerFrameworkVersion, this.artifactFactory, this.artifactResolver, this.remoteArtifactRepositories, this.localRepository);
    }

    public CommandLineExceutor createCommandLineExecutor() {
        if (this.useJavacOutput) {
            return new JavacIOExecutor(this.executable);
        }
        return new MavenIOExecutor(this.executable);
    }
}

