/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.dataflow.qual.Pure;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.FileObject;
import com.sun.javadoc.*;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symbol.ClassSymbol;
import com.sun.tools.javac.code.Symbol.PackageSymbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.JCTree.JCCompilationUnit;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import static com.sun.tools.javac.code.Scope.LookupKind.NON_RECURSIVE;

@Deprecated()
@SuppressWarnings("removal")
public class PackageDocImpl extends DocImpl implements PackageDoc {

    public final PackageSymbol sym;

    public FileObject docPath;

    public boolean setDocPath;

    public PackageDocImpl(DocEnv env, PackageSymbol sym) {
    }

    public PackageDocImpl(DocEnv env, PackageSymbol sym, TreePath treePath) {
    }

    void setTree(JCTree tree);

    public void setTreePath(TreePath treePath);

    protected String documentation();

    public void addAllClassesTo(ListBuffer<ClassDocImpl> list);

    public ClassDoc[] allClasses(boolean filter);

    public ClassDoc[] allClasses();

    public ClassDoc[] ordinaryClasses();

    public ClassDoc[] exceptions();

    public ClassDoc[] errors();

    public ClassDoc[] enums();

    public ClassDoc[] interfaces();

    public AnnotationTypeDoc[] annotationTypes();

    public AnnotationDesc[] annotations();

    public ClassDoc findClass(String className);

    @Pure
    public boolean isIncluded();

    public String name();

    public String qualifiedName();

    public void setDocPath(FileObject path);

    public SourcePosition position();
}
