/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.core.common.type;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import static org.graalvm.compiler.core.common.calc.FloatConvert.I2D;
import static org.graalvm.compiler.core.common.calc.FloatConvert.I2F;
import static org.graalvm.compiler.core.common.calc.FloatConvert.L2D;
import static org.graalvm.compiler.core.common.calc.FloatConvert.L2F;
import java.nio.ByteBuffer;
import java.util.Formatter;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.BinaryOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.FloatConvertOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.IntegerConvertOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.ShiftOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.UnaryOp;
import org.graalvm.compiler.debug.GraalError;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;

public final class IntegerStamp extends PrimitiveStamp {

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput);

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput, long downMask, long upMask);

    public static IntegerStamp stampForMask(int bits, long downMask, long upMask);

    @Override
    public IntegerStamp unrestricted();

    @Override
    public IntegerStamp empty();

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta);

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer);

    @Override
    public boolean hasValues();

    @Override
    public JavaKind getStackKind();

    @Override
    public LIRKind getLIRKind(LIRKindTool tool);

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess);

    public long lowerBound();

    public long upperBound();

    public long downMask();

    public long upMask();

    @Override
    public boolean isUnrestricted();

    public boolean contains(long value);

    public boolean isPositive();

    public boolean isNegative();

    public boolean isStrictlyPositive();

    public boolean isStrictlyNegative();

    public boolean canBePositive();

    public boolean canBeNegative();

    @Override
    public String toString();

    @Override
    public Stamp meet(Stamp otherStamp);

    @Override
    public IntegerStamp join(Stamp otherStamp);

    @Override
    public boolean isCompatible(Stamp stamp);

    @Override
    public boolean isCompatible(Constant constant);

    public long unsignedUpperBound();

    public long unsignedLowerBound();

    @Override
    public int hashCode();

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    public static boolean sameSign(IntegerStamp s1, IntegerStamp s2);

    @Override
    public JavaConstant asConstant();

    public static boolean addCanOverflow(IntegerStamp a, IntegerStamp b);

    public static boolean addOverflowsPositively(long x, long y, int bits);

    public static boolean addOverflowsNegatively(long x, long y, int bits);

    public static long carryBits(long x, long y);

    public static boolean multiplicationOverflows(long a, long b, int bits);

    public static boolean multiplicationCanOverflow(IntegerStamp a, IntegerStamp b);

    public static boolean subtractionCanOverflow(IntegerStamp x, IntegerStamp y);

    public static boolean subtractionOverflows(long x, long y, int bits);

    public static final ArithmeticOpTable OPS;
}
