/*
 * Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.core.common;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public final class LIRKind extends ValueKind<LIRKind> {

    public static final LIRKind Illegal;

    public static LIRKind value(PlatformKind platformKind);

    public static LIRKind reference(PlatformKind platformKind);

    public static LIRKind compressedReference(PlatformKind platformKind);

    public static LIRKind fromJavaKind(Architecture arch, JavaKind javaKind);

    public static LIRKind derivedReference(PlatformKind platformKind, AllocatableValue base, boolean compressed);

    public static LIRKind unknownReference(PlatformKind platformKind);

    public LIRKind makeDerivedReference(AllocatableValue base);

    public static LIRKind combine(Value... inputs);

    public static AllocatableValue derivedBaseFromValue(AllocatableValue value);

    public static LIRKind combineDerived(LIRKind kind, AllocatableValue base1, AllocatableValue base2);

    public static LIRKind mergeReferenceInformation(LIRKind mergeKind, LIRKind inputKind);

    @Override
    public LIRKind changeType(PlatformKind newPlatformKind);

    public LIRKind repeat(PlatformKind newPlatformKind);

    public LIRKind makeUnknownReference();

    public boolean isDerivedReference();

    public AllocatableValue getDerivedReferenceBase();

    public void setDerivedReferenceBase(AllocatableValue derivedReferenceBase);

    public boolean isUnknownReference();

    public static boolean isUnknownReference(ValueKind<?> kind);

    public static boolean isUnknownReference(Value value);

    public int getReferenceCount();

    public boolean isReference(int idx);

    public boolean isCompressedReference(int idx);

    public boolean isValue();

    public static boolean isValue(ValueKind<?> kind);

    public static boolean isValue(Value value);

    @Override
    public String toString();

    @Override
    public int hashCode();

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    public static boolean verifyMoveKinds(ValueKind<?> dst, ValueKind<?> src, RegisterAllocationConfig config);
}
