/*
 * Copyright (c) 2001, 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.java.util.jar.pack;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import static com.sun.java.util.jar.pack.Constants.*;

class Coding implements Comparable<Coding>, CodingMethod, Histogram.BitMetric {

    public static int codeMax(int B, int H, int S, int nMax);

    public static int codeMin(int B, int H, int S, int nMax);

    public static void writeInt(byte[] out, int[] outpos, int sx, int B, int H, int S);

    public static int readInt(byte[] in, int[] inpos, int B, int H, int S);

    public static int readIntFrom(InputStream in, int B, int H, int S) throws IOException;

    public static final int B_MAX;

    public static final int H_MAX;

    public static final int S_MAX;

    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object x);

    public int hashCode();

    public static Coding of(int B, int H);

    public static Coding of(int B, int H, int S);

    public boolean canRepresentValue(int x);

    public boolean canRepresentSigned(int x);

    public boolean canRepresentUnsigned(int x);

    public int readFrom(byte[] in, int[] inpos);

    public void writeTo(byte[] out, int[] outpos, int x);

    public int readFrom(InputStream in) throws IOException;

    public void writeTo(OutputStream out, int x) throws IOException;

    public void readArrayFrom(InputStream in, int[] a, int start, int end) throws IOException;

    public void writeArrayTo(OutputStream out, int[] a, int start, int end) throws IOException;

    boolean isSubrange();

    boolean isFullRange();

    int getRange();

    Coding setB(int B);

    Coding setH(int H);

    Coding setS(int S);

    Coding setL(int L);

    Coding setD(int del);

    Coding getDeltaCoding();

    Coding getValueCoding();

    int reduceToUnsignedRange(long value);

    int reduceToSignedRange(int value);

    static int reduceToSignedRange(int value, int min, int max);

    boolean isSigned();

    boolean isDelta();

    public int B();

    public int H();

    public int L();

    public int S();

    public int del();

    public int min();

    public int max();

    public int umin();

    public int umax();

    public int byteMin(int b);

    public int byteMax(int b);

    public int compareTo(Coding that);

    public int distanceFrom(Coding that);

    static int ceil_lg2(int x);

    static int bitWidth(int i);

    static int[] makeDeltas(int[] values, int start, int end, int min, int max);

    boolean canRepresent(int minValue, int maxValue);

    boolean canRepresent(int[] values, int start, int end);

    public double getBitLength(int value);

    public int getLength(int value);

    public int getLength(int[] values, int start, int end);

    public byte[] getMetaCoding(Coding dflt);

    public static int parseMetaCoding(byte[] bytes, int pos, Coding dflt, CodingMethod[] res);

    public String keyString();

    public String toString();

    String stringForDebug();
}
