/*
 * reserved comment block
 * DO NOT REMOVE OR ALTER!
 */
package org.jcp.xml.dsig.internal.dom;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import javax.xml.crypto.*;
import javax.xml.crypto.dsig.*;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import org.w3c.dom.Element;

public abstract class DOMKeyValue<K extends PublicKey> extends BaseStructure implements KeyValue {

    public DOMKeyValue(K key) throws KeyException {
    }

    public DOMKeyValue(Element kvtElem) throws MarshalException {
    }

    static KeyValue unmarshal(Element kvElem) throws MarshalException;

    @Override
    public PublicKey getPublicKey() throws KeyException;

    public void marshal(XmlWriter xwriter, String dsPrefix, XMLCryptoContext context) throws MarshalException;

    abstract void marshalPublicKey(XmlWriter xwriter, K key, String dsPrefix, XMLCryptoContext context) throws MarshalException;

    abstract K unmarshalKeyValue(Element kvtElem) throws MarshalException;

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    public static BigInteger decode(Element elem) throws MarshalException;

    public static void writeBase64BigIntegerElement(XmlWriter xwriter, String prefix, String localName, String namespaceURI, BigInteger value);

    public static void marshal(XmlWriter xwriter, BigInteger bigNum);

    @Override
    public int hashCode();

    static final class RSA extends DOMKeyValue<RSAPublicKey> {

        @Override
        void marshalPublicKey(XmlWriter xwriter, RSAPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException;

        @Override
        RSAPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException;
    }

    static final class DSA extends DOMKeyValue<DSAPublicKey> {

        @Override
        void marshalPublicKey(XmlWriter xwriter, DSAPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException;

        @Override
        DSAPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException;
    }

    static final class EC extends DOMKeyValue<ECPublicKey> {

        @Override
        void marshalPublicKey(XmlWriter xwriter, ECPublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException;

        @Override
        ECPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException;

        static final class Curve extends ECParameterSpec {
        }
    }

    static final class Unknown extends DOMKeyValue<PublicKey> {

        @Override
        PublicKey unmarshalKeyValue(Element kvElem) throws MarshalException;

        @Override
        void marshalPublicKey(XmlWriter xwriter, PublicKey publicKey, String dsPrefix, XMLCryptoContext context) throws MarshalException;
    }
}
