/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html;

import org.checkerframework.dataflow.qual.Pure;
import java.util.*;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.Navigation;
import jdk.javadoc.internal.doclets.formats.html.markup.Navigation.PageMode;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileIOException;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;

public class SerializedFormWriterImpl extends SubWriterHolderWriter implements SerializedFormWriter {

    public SerializedFormWriterImpl(HtmlConfiguration configuration) {
    }

    public Content getHeader(String header);

    public Content getSerializedSummariesHeader();

    public Content getPackageSerializedHeader();

    public Content getPackageHeader(String packageName);

    public Content getClassSerializedHeader();

    @Pure
    public boolean isVisibleClass(TypeElement typeElement);

    public Content getClassHeader(TypeElement typeElement);

    public Content getSerialUIDInfoHeader();

    public void addSerialUIDInfo(String header, String serialUID, Content serialUidTree);

    public Content getClassContentHeader();

    public Content getSerializedContent(Content serializedTreeContent);

    public void addPackageSerializedTree(Content serializedSummariesTree, Content packageSerializedTree);

    public void addFooter(Content serializedTree);

    @Override
    public void printDocument(Content serializedTree) throws DocFileIOException;

    public SerialFieldWriter getSerialFieldWriter(TypeElement typeElement);

    public SerialMethodWriter getSerialMethodWriter(TypeElement typeElement);
}
