/*
 * Copyright (c) 1998, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html;

import org.checkerframework.dataflow.qual.Pure;
import java.net.*;
import java.util.*;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import com.sun.source.util.DocTreePath;
import com.sun.tools.doclint.DocLint;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlVersion;
import jdk.javadoc.internal.doclets.toolkit.BaseConfiguration;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.DocletException;
import jdk.javadoc.internal.doclets.toolkit.Messages;
import jdk.javadoc.internal.doclets.toolkit.Resources;
import jdk.javadoc.internal.doclets.toolkit.WriterFactory;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import static javax.tools.Diagnostic.Kind.*;

public class HtmlConfiguration extends BaseConfiguration {

    public String header;

    public String packagesheader;

    public String footer;

    public String doctitle;

    public String windowtitle;

    public String top;

    public String bottom;

    public String helpfile;

    public String stylesheetfile;

    public List<String> additionalStylesheets;

    public String docrootparent;

    public boolean nohelp;

    public boolean splitindex;

    public boolean createindex;

    public boolean classuse;

    public boolean createtree;

    public String charset;

    public boolean nodeprecatedlist;

    public boolean nonavbar;

    public String overviewpath;

    public boolean createoverview;

    public boolean frames;

    public HtmlVersion htmlVersion;

    public boolean useModuleDirectories;

    public Map<Doclet.Option, String> doclintOpts;

    public final Resources resources;

    public DocPath topFile;

    public TypeElement currentTypeElement;

    protected SortedSet<SearchIndexItem> memberSearchIndex;

    protected SortedSet<SearchIndexItem> moduleSearchIndex;

    protected SortedSet<SearchIndexItem> packageSearchIndex;

    protected SortedSet<SearchIndexItem> tagSearchIndex;

    protected SortedSet<SearchIndexItem> typeSearchIndex;

    protected Map<Character, List<SearchIndexItem>> tagSearchIndexMap;

    protected Set<Character> tagSearchIndexKeys;

    public final Contents contents;

    protected final Messages messages;

    public DocPaths docPaths;

    public HtmlConfiguration(Doclet doclet) {
    }

    public final String docletVersion;

    @Override
    public String getDocletVersion();

    @Override
    public Resources getResources();

    @Override
    public Messages getMessages();

    protected boolean validateOptions();

    @Override
    public boolean finishOptionSettings();

    @Pure
    public boolean isOutputHtml5();

    public boolean allowTag(HtmlTag htmlTag);

    protected void setTopFile(DocletEnvironment docEnv);

    protected TypeElement getValidClass(List<TypeElement> classes);

    protected boolean checkForDeprecation(DocletEnvironment docEnv);

    protected void setCreateOverview();

    @Override
    public WriterFactory getWriterFactory();

    @Override
    public Locale getLocale();

    @Override
    public JavaFileObject getOverviewPath();

    public DocFile getMainStylesheet();

    public List<DocFile> getAdditionalStylesheets();

    @Override
    public JavaFileManager getFileManager();

    @Override
    public boolean showMessage(DocTreePath path, String key);

    @Override
    public boolean showMessage(Element e, String key);

    @Override
    public String getText(String key);

    @Override
    public String getText(String key, String... args);

    @Override
    public Content getContent(String key);

    @Override
    public Content getContent(String key, Object o);

    @Override
    public Content getContent(String key, Object o1, Object o2);

    @Override
    public Content getContent(String key, Object o0, Object o1, Object o2);

    protected void buildSearchTagIndex();

    @Override
    public Set<Doclet.Option> getSupportedOptions();

    @Override
    protected boolean finishOptionSettings0() throws DocletException;

    @Override
    protected void initConfiguration(DocletEnvironment docEnv);
}
