/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.LocalVariable;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class CatchStatement
extends Statement {
    int mod;
    Expression texpr;
    Identifier id;
    Statement body;
    LocalMember field;

    public CatchStatement(long l, Expression expression, IdentifierToken identifierToken, Statement statement) {
        super(102, l);
        this.mod = identifierToken.getModifiers();
        this.texpr = expression;
        this.id = identifierToken.getName();
        this.body = statement;
    }

    @Deprecated
    public CatchStatement(long l, Expression expression, Identifier identifier, Statement statement) {
        super(102, l);
        this.texpr = expression;
        this.id = identifier;
        this.body = statement;
    }

    @Override
    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.reach(environment, vset);
        context = new Context(context, this);
        Type type = this.texpr.toType(environment, context);
        try {
            if (context.getLocalField(this.id) != null) {
                environment.error(this.where, "local.redefined", this.id);
            }
            if (!type.isType(13)) {
                if (!type.isType(10)) {
                    environment.error(this.where, "catch.not.throwable", type);
                } else {
                    ClassDefinition classDefinition = environment.getClassDefinition(type);
                    if (!classDefinition.subClassOf(environment, environment.getClassDeclaration(idJavaLangThrowable))) {
                        environment.error(this.where, "catch.not.throwable", classDefinition);
                    }
                }
            }
            this.field = new LocalMember(this.where, context.field.getClassDefinition(), this.mod, type, this.id);
            context.declare(environment, this.field);
            vset.addVar(this.field.number);
            return this.body.check(environment, context, vset, hashtable);
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, opNames[this.op]);
            return vset;
        }
    }

    @Override
    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        if (this.field.isUsed()) {
            context.declare(environment, this.field);
        }
        if (this.body != null) {
            this.body = this.body.inline(environment, context);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context context, boolean bl) {
        CatchStatement catchStatement = (CatchStatement)this.clone();
        if (this.body != null) {
            catchStatement.body = this.body.copyInline(context, bl);
        }
        if (this.field != null) {
            catchStatement.field = this.field.copyInline(context);
        }
        return catchStatement;
    }

    @Override
    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1;
        if (this.body != null) {
            n2 += this.body.costInline(n, environment, context);
        }
        return n2;
    }

    @Override
    public void code(Environment environment, Context context, Assembler assembler) {
        CodeContext codeContext = new CodeContext(context, this);
        if (this.field.isUsed()) {
            codeContext.declare(environment, this.field);
            assembler.add(this.where, 58, new LocalVariable(this.field, this.field.number));
        } else {
            assembler.add(this.where, 87);
        }
        if (this.body != null) {
            this.body.code(environment, codeContext, assembler);
        }
    }

    @Override
    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("catch (");
        this.texpr.print(printStream);
        printStream.print(" " + this.id + ") ");
        if (this.body != null) {
            this.body.print(printStream, n);
        } else {
            printStream.print("<empty>");
        }
    }
}

