/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.sun.jarsigner.ContentSigner;
import com.sun.jarsigner.ContentSignerParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.HttpTimestamper;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.TimestampToken;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public final class TimestampedSigner
extends ContentSigner {
    private static final SecureRandom RANDOM;
    private static final String SUBJECT_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.11";
    private static final String KP_TIMESTAMPING_OID = "1.3.6.1.5.5.7.3.8";
    private static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    private static final ObjectIdentifier AD_TIMESTAMPING_Id;
    private String tsaUrl = null;
    private X509Certificate tsaCertificate = null;
    private MessageDigest messageDigest = null;
    private boolean tsRequestCertificate = true;

    @Override
    public byte[] generateSignedData(ContentSignerParameters contentSignerParameters, boolean bl, boolean bl2) throws NoSuchAlgorithmException, CertificateException, IOException {
        Object object;
        Object object2;
        SignerInfo[] signerInfoArray;
        Object object3;
        if (contentSignerParameters == null) {
            throw new NullPointerException();
        }
        String string = contentSignerParameters.getSignatureAlgorithm();
        String string2 = AlgorithmId.getEncAlgFromSigAlg((String)string);
        String string3 = AlgorithmId.getDigAlgFromSigAlg((String)string);
        AlgorithmId algorithmId = AlgorithmId.get(string3);
        X509Certificate[] x509CertificateArray = contentSignerParameters.getSignerCertificateChain();
        Principal principal = x509CertificateArray[0].getIssuerDN();
        if (!(principal instanceof X500Name)) {
            object3 = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
            principal = (Principal)object3.get("issuer.dname");
        }
        object3 = x509CertificateArray[0].getSerialNumber();
        byte[] byArray = contentSignerParameters.getContent();
        ContentInfo contentInfo = bl ? new ContentInfo(ContentInfo.DATA_OID, null) : new ContentInfo(byArray);
        byte[] byArray2 = contentSignerParameters.getSignature();
        SignerInfo signerInfo = null;
        if (bl2) {
            this.tsaCertificate = contentSignerParameters.getTimestampingAuthorityCertificate();
            signerInfoArray = contentSignerParameters.getTimestampingAuthority();
            if (signerInfoArray != null) {
                this.tsaUrl = signerInfoArray.toString();
            } else {
                object2 = TimestampedSigner.getTimestampingUrl(this.tsaCertificate);
                if (object2 == null) {
                    throw new CertificateException("Subject Information Access extension not found");
                }
                this.tsaUrl = object2;
            }
            object2 = this.generateTimestampToken(byArray2);
            object = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute("SignatureTimestampToken", object2)});
            signerInfo = new SignerInfo((X500Name)principal, (BigInteger)object3, algorithmId, null, AlgorithmId.get(string2), byArray2, (PKCS9Attributes)object);
        } else {
            signerInfo = new SignerInfo((X500Name)principal, (BigInteger)object3, algorithmId, AlgorithmId.get(string2), byArray2);
        }
        signerInfoArray = new SignerInfo[]{signerInfo};
        object2 = new AlgorithmId[]{algorithmId};
        object = new PKCS7((AlgorithmId[])object2, contentInfo, x509CertificateArray, null, signerInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object.encodeSignedData((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String getTimestampingUrl(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue(SUBJECT_INFO_ACCESS_OID);
            if (byArray == null) {
                return null;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            derInputStream = new DerInputStream(derInputStream.getOctetString());
            DerValue[] derValueArray = derInputStream.getSequence(5);
            for (int i = 0; i < derValueArray.length; ++i) {
                URIName uRIName;
                GeneralName generalName;
                AccessDescription accessDescription = new AccessDescription(derValueArray[i]);
                if (!accessDescription.getAccessMethod().equals(AD_TIMESTAMPING_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6 || !(uRIName = (URIName)generalName.getName()).getScheme().equalsIgnoreCase("http") && !uRIName.getScheme().equalsIgnoreCase("https")) continue;
                return uRIName.getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private byte[] generateTimestampToken(byte[] byArray) throws CertificateException, IOException {
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        byte[] byArray2 = this.messageDigest.digest(byArray);
        TSRequest tSRequest = new TSRequest(byArray2, "SHA-1");
        BigInteger bigInteger = null;
        if (RANDOM != null) {
            bigInteger = new BigInteger(64, RANDOM);
            tSRequest.setNonce(bigInteger);
        }
        tSRequest.requestCertificate(this.tsRequestCertificate);
        HttpTimestamper httpTimestamper = new HttpTimestamper(this.tsaUrl);
        TSResponse tSResponse = httpTimestamper.generateTimestamp(tSRequest);
        int n = tSResponse.getStatusCode();
        if (n != 0 && n != 1) {
            int n2 = tSResponse.getFailureCode();
            if (n2 == -1) {
                throw new IOException("Error generating timestamp: " + tSResponse.getStatusCodeAsText());
            }
            throw new IOException("Error generating timestamp: " + tSResponse.getStatusCodeAsText() + " " + tSResponse.getFailureCodeAsText());
        }
        PKCS7 pKCS7 = tSResponse.getToken();
        TimestampToken timestampToken = new TimestampToken(pKCS7.getContentInfo().getData());
        if (!timestampToken.getHashAlgorithm().equals(new AlgorithmId(new ObjectIdentifier("1.3.14.3.2.26")))) {
            throw new IOException("Digest algorithm not SHA-1 in timestamp token");
        }
        if (!Arrays.equals(timestampToken.getHashedMessage(), byArray2)) {
            throw new IOException("Digest octets changed in timestamp token");
        }
        BigInteger bigInteger2 = timestampToken.getNonce();
        if (bigInteger2 == null && bigInteger != null) {
            throw new IOException("Nonce missing in timestamp token");
        }
        if (bigInteger2 != null && !bigInteger2.equals(bigInteger)) {
            throw new IOException("Nonce changed in timestamp token");
        }
        for (SignerInfo signerInfo : pKCS7.getSignerInfos()) {
            X509Certificate x509Certificate = signerInfo.getCertificate(pKCS7);
            if (x509Certificate == null) {
                throw new CertificateException("Certificate not included in timestamp token");
            }
            if (!x509Certificate.getCriticalExtensionOIDs().contains(EXTENDED_KEY_USAGE_OID)) {
                throw new CertificateException("Certificate is not valid for timestamping");
            }
            List<String> list = x509Certificate.getExtendedKeyUsage();
            if (list != null && list.contains(KP_TIMESTAMPING_OID)) continue;
            throw new CertificateException("Certificate is not valid for timestamping");
        }
        return tSResponse.getEncodedToken();
    }

    static {
        Serializable serializable = null;
        try {
            serializable = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        RANDOM = serializable;
        serializable = null;
        try {
            serializable = new ObjectIdentifier("1.3.6.1.5.5.7.48.3");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AD_TIMESTAMPING_Id = serializable;
    }
}

