/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;

public abstract class AbstractMonitor
implements Monitor {
    protected String name;
    protected Units units;
    protected Variability variability;
    protected int vectorLength;
    protected boolean supported;

    protected AbstractMonitor(String string, Units units, Variability variability, boolean bl, int n) {
        this.name = string;
        this.units = units;
        this.variability = variability;
        this.vectorLength = n;
        this.supported = bl;
    }

    protected AbstractMonitor(String string, Units units, Variability variability, boolean bl) {
        this(string, units, variability, bl, 0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        int n = this.name.lastIndexOf(".") + 1;
        return this.name.substring(n);
    }

    @Override
    public Units getUnits() {
        return this.units;
    }

    @Override
    public Variability getVariability() {
        return this.variability;
    }

    @Override
    public boolean isVector() {
        return this.vectorLength > 0;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public abstract Object getValue();
}

