/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.tree.analysis;

import java.util.Set;
import org.checkerframework.org.objectweb.asm.tree.AbstractInsnNode;
import org.checkerframework.org.objectweb.asm.tree.analysis.SmallSet;
import org.checkerframework.org.objectweb.asm.tree.analysis.Value;

public class DataflowValue
implements Value {
    public final int size;
    public final Set insns;

    public DataflowValue(int size) {
        this(size, SmallSet.EMPTY_SET);
    }

    public DataflowValue(int size, AbstractInsnNode insn) {
        this.size = size;
        this.insns = new SmallSet(insn, null);
    }

    public DataflowValue(int size, Set insns) {
        this.size = size;
        this.insns = insns;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean equals(Object value) {
        DataflowValue v = (DataflowValue)value;
        return this.size == v.size && this.insns.equals(v.insns);
    }

    public int hashCode() {
        return this.insns.hashCode();
    }
}

