/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.qual.PolymorphicQualifier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class QualifierPolymorphism {
    private final Types types;
    private final AnnotatedTypeFactory atypeFactory;
    private final Completer completer;
    protected final Map<AnnotationMirror, AnnotationMirror> polyQuals;
    protected final Set<? extends AnnotationMirror> topQuals;
    protected final QualifierHierarchy qualhierarchy;
    private final AnnotationMirror POLYALL;
    private final AnnotatedTypeScanner<Void, Map<AnnotationMirror, Set<? extends AnnotationMirror>>> replacer = new AnnotatedTypeScanner<Void, Map<AnnotationMirror, Set<? extends AnnotationMirror>>>(){

        @Override
        public Void scan(AnnotatedTypeMirror type, Map<AnnotationMirror, Set<? extends AnnotationMirror>> matches) {
            for (Map.Entry<AnnotationMirror, Set<? extends AnnotationMirror>> pqentry : matches.entrySet()) {
                AnnotationMirror poly = pqentry.getKey();
                if (poly == null || !type.hasAnnotation(poly)) continue;
                type.removeAnnotation(poly);
                Set<? extends AnnotationMirror> quals = pqentry.getValue();
                type.replaceAnnotations(quals);
            }
            return (Void)super.scan(type, matches);
        }
    };
    private final PolyCollector collector;

    public QualifierPolymorphism(ProcessingEnvironment env, AnnotatedTypeFactory factory) {
        this.atypeFactory = factory;
        this.types = env.getTypeUtils();
        Elements elements = env.getElementUtils();
        this.POLYALL = AnnotationBuilder.fromClass(elements, PolyAll.class);
        this.qualhierarchy = factory.getQualifierHierarchy();
        HashMap<AnnotationMirror, AnnotationMirror> polys = new HashMap<AnnotationMirror, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : this.qualhierarchy.getTypeQualifiers()) {
            if (QualifierPolymorphism.isPolyAll(annotationMirror)) {
                polys.put(null, annotationMirror);
                continue;
            }
            for (AnnotationMirror annotationMirror2 : annotationMirror.getAnnotationType().asElement().getAnnotationMirrors()) {
                AnnotationMirror ttreetop;
                if (!annotationMirror2.getAnnotationType().toString().equals(PolymorphicQualifier.class.getCanonicalName())) continue;
                Name plval = AnnotationUtils.getElementValueClassName(annotationMirror2, "value", true);
                if (PolymorphicQualifier.class.getCanonicalName().contentEquals(plval)) {
                    Set<? extends AnnotationMirror> tops = this.qualhierarchy.getTopAnnotations();
                    if (tops.size() != 1) {
                        ErrorReporter.errorAbort("QualifierPolymorphism: PolymorphicQualifier has to specify type hierarchy, if more than one exist; top types: " + tops);
                    }
                    ttreetop = tops.iterator().next();
                } else {
                    AnnotationMirror ttree = AnnotationBuilder.fromName(elements, plval);
                    ttreetop = this.qualhierarchy.getTopAnnotation(ttree);
                }
                if (polys.containsKey(ttreetop)) {
                    ErrorReporter.errorAbort("QualifierPolymorphism: checker has multiple polymorphic qualifiers: " + polys.get(ttreetop) + " and " + annotationMirror);
                }
                polys.put(ttreetop, annotationMirror);
            }
        }
        this.polyQuals = polys;
        this.topQuals = this.qualhierarchy.getTopAnnotations();
        this.collector = new PolyCollector();
        this.completer = new Completer();
    }

    public static AnnotationMirror getPolymorphicQualifier(AnnotationMirror qual) {
        if (qual == null) {
            return null;
        }
        Element qualElt = qual.getAnnotationType().asElement();
        for (AnnotationMirror annotationMirror : qualElt.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(PolymorphicQualifier.class.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isPolymorphicQualified(AnnotationMirror qual) {
        return QualifierPolymorphism.getPolymorphicQualifier(qual) != null;
    }

    public static boolean isPolyAll(AnnotationMirror qual) {
        return AnnotationUtils.areSameByClass(qual, PolyAll.class);
    }

    public static Class<? extends Annotation> getPolymorphicQualifierTop(Elements elements, AnnotationMirror qual) {
        AnnotationMirror poly = QualifierPolymorphism.getPolymorphicQualifier(qual);
        if (poly == null) {
            return null;
        }
        Class<?> ret = AnnotationUtils.getElementValueClass(poly, "value", true);
        return ret;
    }

    public void annotate(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        if (TreeUtils.isEnumSuper(tree)) {
            return;
        }
        List<AnnotatedTypeMirror> parameters = AnnotatedTypes.expandVarArgs(this.atypeFactory, type, tree.getArguments());
        List<AnnotatedTypeMirror> arguments = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, parameters, tree.getArguments());
        Map<AnnotationMirror, Set<? extends AnnotationMirror>> matchingMapping = this.collector.visit(arguments, parameters);
        if (type.getReceiverType() != null && !TreeUtils.isSuperCall(tree) && !TreeUtils.isThisCall(tree)) {
            matchingMapping = this.collector.reduce(matchingMapping, (Map)this.collector.visit(this.atypeFactory.getReceiverType(tree), type.getReceiverType()));
        }
        if (matchingMapping != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type, matchingMapping);
        } else {
            this.completer.visit(type);
        }
    }

    public void annotate(NewClassTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, type, tree.getArguments());
        List<AnnotatedTypeMirror> arguments = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, requiredArgs, tree.getArguments());
        Map<AnnotationMirror, Set<? extends AnnotationMirror>> matchingMapping = this.collector.visit(arguments, requiredArgs);
        if (matchingMapping != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type, matchingMapping);
        } else {
            this.completer.visit(type);
        }
    }

    public void annotate(AnnotatedTypeMirror.AnnotatedExecutableType functionalInterface, AnnotatedTypeMirror.AnnotatedExecutableType memberReference) {
        Map<AnnotationMirror, Set<? extends AnnotationMirror>> matchingMapping;
        for (AnnotationMirror type : functionalInterface.getReturnType().getAnnotations()) {
            if (!QualifierPolymorphism.isPolymorphicQualified(type)) continue;
            return;
        }
        List<AnnotatedTypeMirror> args = functionalInterface.getParameterTypes();
        List<AnnotatedTypeMirror> requiredArgs = memberReference.getParameterTypes();
        if (args.size() == requiredArgs.size() + 1) {
            ArrayList<AnnotatedTypeMirror> newRequiredArgs = new ArrayList<AnnotatedTypeMirror>();
            newRequiredArgs.add(memberReference.getReceiverType());
            newRequiredArgs.addAll(requiredArgs);
            requiredArgs = newRequiredArgs;
        }
        if (memberReference.isVarArgs() && !functionalInterface.isVarArgs()) {
            requiredArgs = AnnotatedTypes.expandVarArgsFromTypes(memberReference, args);
        }
        if ((matchingMapping = this.collector.visit(args, requiredArgs)) != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(memberReference, matchingMapping);
        } else {
            this.completer.visit(memberReference);
        }
    }

    private class PolyCollector
    extends SimpleAnnotatedTypeVisitor<Map<AnnotationMirror, Set<? extends AnnotationMirror>>, AnnotatedTypeMirror> {
        private final Set<TypeMirror> visited = new HashSet<TypeMirror>();

        private PolyCollector() {
        }

        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> reduce(Map<AnnotationMirror, Set<? extends AnnotationMirror>> r1, Map<AnnotationMirror, Set<? extends AnnotationMirror>> r2) {
            if (r1 == null || r1.isEmpty()) {
                return r2;
            }
            if (r2 == null || r2.isEmpty()) {
                return r1;
            }
            HashMap<AnnotationMirror, Set<? extends AnnotationMirror>> res = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>(r1.size());
            Set<AnnotationMirror> r2remain = AnnotationUtils.createAnnotationSet();
            r2remain.addAll(r2.keySet());
            for (Map.Entry<AnnotationMirror, Set<? extends AnnotationMirror>> kv1 : r1.entrySet()) {
                AnnotationMirror key1 = kv1.getKey();
                Set<? extends AnnotationMirror> a1Annos = kv1.getValue();
                Set<? extends AnnotationMirror> a2Annos = r2.get(key1);
                if (a2Annos != null && !a2Annos.isEmpty()) {
                    r2remain.remove(key1);
                    Set<? extends AnnotationMirror> lubs = QualifierPolymorphism.this.qualhierarchy.leastUpperBounds(a1Annos, a2Annos);
                    res.put(key1, lubs);
                    continue;
                }
                res.put(key1, a1Annos);
            }
            for (AnnotationMirror key2 : r2remain) {
                res.put(key2, r2.get(key2));
            }
            return res;
        }

        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result = this.reduce(result, (Map)this.visit(type, actualType));
            }
            return result;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.INTERSECTION) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                Map result;
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)actualType;
                this.visited.add(actualType.getUnderlyingType());
                if (wctype.getUnderlyingType().getExtendsBound() != null) {
                    result = (Map)this.visit(type, wctype.getExtendsBound());
                } else if (wctype.getUnderlyingType().getSuperBound() != null) {
                    if (TypesUtils.isErasedSubtype(type.getUnderlyingType(), wctype.getSuperBound().getUnderlyingType(), QualifierPolymorphism.this.types)) {
                        result = (Map)this.visit(type, wctype.getSuperBound());
                    } else if (wctype.getSuperBound().getKind() == TypeKind.NULL) {
                        result = Collections.emptyMap();
                    } else {
                        AnnotatedTypeMirror.AnnotatedDeclaredType superBoundAsSuper = AnnotatedTypes.asSuper(QualifierPolymorphism.this.atypeFactory, wctype.getSuperBound(), type);
                        result = (Map)this.visit(type, superBoundAsSuper);
                    }
                } else {
                    result = Collections.emptyMap();
                }
                this.visited.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() != type.getKind() || actualType == type) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type.getKind());
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            type = AnnotatedTypes.asSuper(QualifierPolymorphism.this.atypeFactory, type, dcType);
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result = this.mapQualifierToPoly(type, dcType);
            if (!type.wasRaw() && !dcType.wasRaw()) {
                result = this.reduce(result, this.visit(type.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror actualType) {
            return this.mapQualifierToPoly(type, actualType);
        }

        private Map<AnnotationMirror, Set<? extends AnnotationMirror>> mapQualifierToPoly(AnnotatedTypeMirror type, AnnotatedTypeMirror actualType) {
            HashMap<AnnotationMirror, Set<? extends AnnotationMirror>> result = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = kv.getKey();
                AnnotationMirror poly = kv.getValue();
                if (top == null && actualType.hasAnnotation(QualifierPolymorphism.this.POLYALL)) {
                    result.put(poly, type.getAnnotations());
                    continue;
                }
                if (!actualType.hasAnnotation(poly)) continue;
                AnnotationMirror typeQual = type.getAnnotationInHierarchy(top);
                result.put(poly, Collections.singleton(typeQual));
            }
            return result;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitNull(AnnotatedTypeMirror.AnnotatedNullType type, AnnotatedTypeMirror actualType) {
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result = this.mapQualifierToPoly(type, actualType);
            if (!result.isEmpty()) {
                return result;
            }
            return (Map)super.visitNull(type, actualType);
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.INTERSECTION) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(AnnotatedTypes.asSuper(QualifierPolymorphism.this.atypeFactory, type, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result;
            }
            assert (type.getKind() == actualType.getKind()) : actualType;
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result = this.mapQualifierToPoly(type, actualType);
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            result = this.reduce(result, (Map)this.visit(type.getComponentType(), arType.getComponentType()));
            return result;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = AnnotatedTypes.asSuper(QualifierPolymorphism.this.atypeFactory, type, actualType);
            if (typeSuper.getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            if (typeSuper.getKind() == actualType.getKind() && type.getKind() == actualType.getKind()) {
                AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(type.getUnderlyingType());
                Map result = (Map)this.visit(type.getUpperBound(), tvType.getUpperBound());
                this.visited.remove(type.getUnderlyingType());
                return result;
            }
            return (Map)this.visit(type.getUpperBound(), actualType);
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror actualType) {
            if (type.isUninferredTypeArgument() || !TypesUtils.isErasedSubtype(type.getUnderlyingType(), actualType.getUnderlyingType(), QualifierPolymorphism.this.types)) {
                return this.mapQualifierToPoly(type.getExtendsBound(), actualType);
            }
            AnnotatedTypeMirror typeSuper = AnnotatedTypes.asSuper(QualifierPolymorphism.this.atypeFactory, type, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            if (((Type.WildcardType)typeSuper.getUnderlyingType()).isUnbound()) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() != TypeKind.WILDCARD && actualType.getKind() != TypeKind.TYPEVAR) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (this.visited.contains(actualType.getUnderlyingType())) {
                return Collections.emptyMap();
            }
            this.visited.add(type.getUnderlyingType());
            Map result = type.getExtendsBound() != null && wcType.getExtendsBound() != null ? (Map)this.visit(type.getExtendsBound(), wcType.getExtendsBound()) : (type.getSuperBound() != null && wcType.getSuperBound() != null ? (Map)this.visit(type.getSuperBound(), wcType.getSuperBound()) : new HashMap());
            this.visited.remove(type.getUnderlyingType());
            return result;
        }
    }

    class Completer
    extends AnnotatedTypeScanner<Void, Void> {
        Completer() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void p) {
            for (Map.Entry<AnnotationMirror, AnnotationMirror> pqentry : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = pqentry.getKey();
                AnnotationMirror poly = pqentry.getValue();
                if (!type.hasAnnotation(poly)) continue;
                type.removeAnnotation(poly);
                if (top == null) {
                    type.addMissingAnnotations(QualifierPolymorphism.this.topQuals);
                    continue;
                }
                if (type.getKind() == TypeKind.TYPEVAR || type.getKind() == TypeKind.WILDCARD) continue;
                type.addAnnotation(top);
            }
            return (Void)super.scan(type, p);
        }
    }
}

