/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.javacutil.TreeUtils;

class ValueMethodIdentifier {
    private final ExecutableElement lengthMethod;
    private final ExecutableElement startsWithMethod;
    private final ExecutableElement endsWithMethod;

    public ValueMethodIdentifier(ProcessingEnvironment processingEnv) {
        this.lengthMethod = TreeUtils.getMethod("java.lang.String", "length", 0, processingEnv);
        this.startsWithMethod = TreeUtils.getMethod("java.lang.String", "startsWith", 1, processingEnv);
        this.endsWithMethod = TreeUtils.getMethod("java.lang.String", "endsWith", 1, processingEnv);
    }

    public boolean isStringLengthInvocation(Tree tree, ProcessingEnvironment processingEnv) {
        return TreeUtils.isMethodInvocation(tree, this.lengthMethod, processingEnv);
    }

    public boolean isStringLengthMethod(ExecutableElement method) {
        return method.equals(this.lengthMethod);
    }

    public boolean isStartsWithMethod(ExecutableElement method) {
        return method.equals(this.startsWithMethod);
    }

    public boolean isEndsWithMethod(ExecutableElement method) {
        return method.equals(this.endsWithMethod);
    }
}

