/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser;

import org.checkerframework.com.github.javaparser.JavaToken;
import org.checkerframework.com.github.javaparser.Position;
import org.checkerframework.com.github.javaparser.Range;
import org.checkerframework.com.github.javaparser.Token;
import org.checkerframework.com.github.javaparser.TokenRange;
import org.checkerframework.com.github.javaparser.ast.comments.BlockComment;
import org.checkerframework.com.github.javaparser.ast.comments.Comment;
import org.checkerframework.com.github.javaparser.ast.comments.JavadocComment;
import org.checkerframework.com.github.javaparser.ast.comments.LineComment;

abstract class GeneratedJavaParserTokenManagerBase {
    GeneratedJavaParserTokenManagerBase() {
    }

    private static TokenRange tokenRange(Token token) {
        JavaToken javaToken = token.javaToken;
        return new TokenRange(javaToken, javaToken);
    }

    static Comment createCommentFromToken(Token token) {
        String commentText = token.image;
        if (token.kind == 8) {
            return new JavadocComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(3, commentText.length() - 2));
        }
        if (token.kind == 9) {
            return new BlockComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(2, commentText.length() - 2));
        }
        if (token.kind == 5) {
            Range range = new Range(Position.pos(token.beginLine, token.beginColumn), Position.pos(token.endLine, token.endColumn));
            while (commentText.endsWith("\r") || commentText.endsWith("\n")) {
                commentText = commentText.substring(0, commentText.length() - 1);
            }
            range = range.withEnd(Position.pos(range.begin.line, range.begin.column + commentText.length()));
            LineComment comment = new LineComment(GeneratedJavaParserTokenManagerBase.tokenRange(token), commentText.substring(2));
            comment.setRange(range);
            return comment;
        }
        throw new AssertionError((Object)"Unexpectedly got passed a non-comment token.");
    }
}

