/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

abstract class ConnectorImpl
implements Connector {
    Map<String, Connector.Argument> defaultArguments = new LinkedHashMap<String, Connector.Argument>();
    static String trueString = null;
    static String falseString;
    private ResourceBundle messages = null;

    ConnectorImpl() {
    }

    @Override
    public Map<String, Connector.Argument> defaultArguments() {
        LinkedHashMap<String, Connector.Argument> linkedHashMap = new LinkedHashMap<String, Connector.Argument>();
        Collection<Connector.Argument> collection = this.defaultArguments.values();
        for (ArgumentImpl argumentImpl : collection) {
            linkedHashMap.put(argumentImpl.name(), (Connector.Argument)argumentImpl.clone());
        }
        return linkedHashMap;
    }

    void addStringArgument(String string, String string2, String string3, String string4, boolean bl) {
        this.defaultArguments.put(string, new StringArgumentImpl(string, string2, string3, string4, bl));
    }

    void addBooleanArgument(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.defaultArguments.put(string, new BooleanArgumentImpl(string, string2, string3, bl, bl2));
    }

    void addIntegerArgument(String string, String string2, String string3, String string4, boolean bl, int n, int n2) {
        this.defaultArguments.put(string, new IntegerArgumentImpl(string, string2, string3, string4, bl, n, n2));
    }

    void addSelectedArgument(String string, String string2, String string3, String string4, boolean bl, List<String> list) {
        this.defaultArguments.put(string, new SelectedArgumentImpl(string, string2, string3, string4, bl, list));
    }

    ArgumentImpl argument(String string, Map map) throws IllegalConnectorArgumentsException {
        ArgumentImpl argumentImpl = (ArgumentImpl)map.get(string);
        if (argumentImpl == null) {
            throw new IllegalConnectorArgumentsException("Argument missing", string);
        }
        String string2 = argumentImpl.value();
        if (string2 == null || string2.length() == 0) {
            if (argumentImpl.mustSpecify()) {
                throw new IllegalConnectorArgumentsException("Argument unspecified", string);
            }
        } else if (!argumentImpl.isValid(string2)) {
            throw new IllegalConnectorArgumentsException("Argument invalid", string);
        }
        return argumentImpl;
    }

    String getString(String string) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
        }
        return this.messages.getString(string);
    }

    public String toString() {
        String string = this.name() + " (defaults: ";
        Iterator<Connector.Argument> iterator = this.defaultArguments().values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ArgumentImpl argumentImpl = (ArgumentImpl)iterator.next();
            if (!bl) {
                string = string + ", ";
            }
            string = string + argumentImpl.toString();
            bl = false;
        }
        string = string + ")";
        return string;
    }

    abstract class ArgumentImpl
    implements Connector.Argument,
    Cloneable,
    Serializable {
        private String name;
        private String label;
        private String description;
        private String value;
        private boolean mustSpecify;

        ArgumentImpl(String string, String string2, String string3, String string4, boolean bl) {
            this.name = string;
            this.label = string2;
            this.description = string3;
            this.value = string4;
            this.mustSpecify = bl;
        }

        @Override
        public abstract boolean isValid(String var1);

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void setValue(String string) {
            if (string == null) {
                throw new NullPointerException("Can't set null value");
            }
            this.value = string;
        }

        @Override
        public boolean mustSpecify() {
            return this.mustSpecify;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Connector.Argument) {
                Connector.Argument argument = (Connector.Argument)object;
                return this.name().equals(argument.name()) && this.description().equals(argument.description()) && this.mustSpecify() == argument.mustSpecify() && this.value().equals(argument.value());
            }
            return false;
        }

        public int hashCode() {
            return this.description().hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalException();
            }
        }

        public String toString() {
            return this.name() + "=" + this.value();
        }
    }

    class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        BooleanArgumentImpl(String string, String string2, String string3, boolean bl, boolean bl2) {
            super(string, string2, string3, null, bl2);
            if (trueString == null) {
                trueString = ConnectorImpl.this.getString("true");
                falseString = ConnectorImpl.this.getString("false");
            }
            this.setValue(bl);
        }

        @Override
        public void setValue(boolean bl) {
            this.setValue(this.stringValueOf(bl));
        }

        @Override
        public boolean isValid(String string) {
            return string.equals(trueString) || string.equals(falseString);
        }

        @Override
        public String stringValueOf(boolean bl) {
            return bl ? trueString : falseString;
        }

        @Override
        public boolean booleanValue() {
            return this.value().equals(trueString);
        }
    }

    class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private final int min;
        private final int max;

        IntegerArgumentImpl(String string, String string2, String string3, String string4, boolean bl, int n, int n2) {
            super(string, string2, string3, string4, bl);
            this.min = n;
            this.max = n2;
        }

        @Override
        public void setValue(int n) {
            this.setValue(this.stringValueOf(n));
        }

        @Override
        public boolean isValid(String string) {
            if (string == null) {
                return false;
            }
            try {
                return this.isValid(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public boolean isValid(int n) {
            return this.min <= n && n <= this.max;
        }

        @Override
        public String stringValueOf(int n) {
            return "" + n;
        }

        @Override
        public int intValue() {
            if (this.value() == null) {
                return 0;
            }
            try {
                return Integer.decode(this.value());
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public int min() {
            return this.min;
        }
    }

    class SelectedArgumentImpl
    extends ArgumentImpl
    implements Connector.SelectedArgument {
        private final List<String> choices;

        SelectedArgumentImpl(String string, String string2, String string3, String string4, boolean bl, List<String> list) {
            super(string, string2, string3, string4, bl);
            this.choices = Collections.unmodifiableList(new ArrayList<String>(list));
        }

        @Override
        public List<String> choices() {
            return this.choices;
        }

        @Override
        public boolean isValid(String string) {
            return this.choices.contains(string);
        }
    }

    class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        StringArgumentImpl(String string, String string2, String string3, String string4, boolean bl) {
            super(string, string2, string3, string4, bl);
        }

        @Override
        public boolean isValid(String string) {
            return true;
        }
    }
}

