/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.LineNumberTable_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class SourceWriter
extends InstructionDetailWriter {
    private JavaFileManager fileManager;
    private ClassFile classFile;
    private SortedMap<Integer, SortedSet<Integer>> lineMap;
    private List<Integer> lineList;
    private String[] sourceLines;

    static SourceWriter instance(Context context) {
        SourceWriter sourceWriter = context.get(SourceWriter.class);
        if (sourceWriter == null) {
            sourceWriter = new SourceWriter(context);
        }
        return sourceWriter;
    }

    protected SourceWriter(Context context) {
        super(context);
        context.put(SourceWriter.class, this);
    }

    void setFileManager(JavaFileManager javaFileManager) {
        this.fileManager = javaFileManager;
    }

    public void reset(ClassFile classFile, Code_attribute code_attribute) {
        this.setSource(classFile);
        this.setLineMap(code_attribute);
    }

    @Override
    public void writeDetails(Instruction instruction) {
        String string = this.space(40);
        Set set = (Set)this.lineMap.get(instruction.getPC());
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.print(string);
                this.print(String.format(" %4d ", n));
                if (n < this.sourceLines.length) {
                    this.print(this.sourceLines[n]);
                }
                this.println();
                int n2 = this.nextLine(n);
                for (int i = n + 1; i < n2; ++i) {
                    this.print(string);
                    this.print(String.format("(%4d)", i));
                    if (i < this.sourceLines.length) {
                        this.print(this.sourceLines[i]);
                    }
                    this.println();
                }
            }
        }
    }

    public boolean hasSource() {
        return this.sourceLines.length > 0;
    }

    private void setLineMap(Code_attribute code_attribute) {
        TreeMap<Integer, SortedSet<Integer>> treeMap = new TreeMap<Integer, SortedSet<Integer>>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Attribute attribute : code_attribute.attributes) {
            if (!(attribute instanceof LineNumberTable_attribute)) continue;
            LineNumberTable_attribute lineNumberTable_attribute = (LineNumberTable_attribute)attribute;
            for (LineNumberTable_attribute.Entry entry : lineNumberTable_attribute.line_number_table) {
                int n = entry.start_pc;
                int n2 = entry.line_number;
                TreeSet<Integer> treeSet2 = (TreeSet<Integer>)treeMap.get(n);
                if (treeSet2 == null) {
                    treeSet2 = new TreeSet<Integer>();
                    treeMap.put(n, treeSet2);
                }
                treeSet2.add(n2);
                treeSet.add(n2);
            }
        }
        this.lineMap = treeMap;
        this.lineList = new ArrayList<Integer>(treeSet);
    }

    private void setSource(ClassFile classFile) {
        if (classFile != this.classFile) {
            this.classFile = classFile;
            this.sourceLines = SourceWriter.splitLines(this.readSource(classFile));
        }
    }

    private String readSource(ClassFile classFile) {
        if (this.fileManager == null) {
            return null;
        }
        StandardLocation standardLocation = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        try {
            String string = classFile.getName();
            SourceFile_attribute sourceFile_attribute = (SourceFile_attribute)classFile.attributes.get("SourceFile");
            if (sourceFile_attribute == null) {
                this.report(this.messages.getMessage("err.no.SourceFile.attribute", new Object[0]));
                return null;
            }
            String string2 = sourceFile_attribute.getSourceFile(classFile.constant_pool);
            String string3 = string2.endsWith(".java") ? string2.substring(0, string2.length() - 5) : string2;
            int n = string.lastIndexOf("/");
            String string4 = n == -1 ? "" : string.substring(0, n + 1);
            String string5 = (string4 + string3).replace('/', '.');
            JavaFileObject javaFileObject = this.fileManager.getJavaFileForInput(standardLocation, string5, JavaFileObject.Kind.SOURCE);
            if (javaFileObject == null) {
                this.report(this.messages.getMessage("err.source.file.not.found", new Object[0]));
                return null;
            }
            return javaFileObject.getCharContent(true).toString();
        }
        catch (ConstantPoolException constantPoolException) {
            this.report(constantPoolException);
            return null;
        }
        catch (IOException iOException) {
            this.report(iOException.getLocalizedMessage());
            return null;
        }
    }

    private static String[] splitLines(String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private int nextLine(int n) {
        int n2 = this.lineList.indexOf(n);
        if (n2 == -1 || n2 == this.lineList.size() - 1) {
            return -1;
        }
        return this.lineList.get(n2 + 1);
    }
}

