/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.JavadocTodo;
import com.sun.tools.javadoc.Messager;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavadocTool
extends JavaCompiler {
    DocEnv docenv;
    final Context context;
    final Messager messager;
    final JavadocClassReader reader;
    final JavadocEnter enter;
    final Annotate annotate;
    static final boolean surrogatesSupported = JavadocTool.surrogatesSupported();

    protected JavadocTool(Context context) {
        super(context);
        this.context = context;
        this.messager = Messager.instance0(context);
        this.reader = JavadocClassReader.instance0(context);
        this.enter = JavadocEnter.instance0(context);
        this.annotate = Annotate.instance(context);
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    public static JavadocTool make0(Context context) {
        AbstractLog abstractLog = null;
        try {
            JavadocClassReader.preRegister(context);
            JavadocEnter.preRegister(context);
            JavadocMemberEnter.preRegister(context);
            JavadocTodo.preRegister(context);
            abstractLog = Messager.instance0(context);
            return new JavadocTool(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            abstractLog.error(-1, completionFailure.getMessage(), new Object[0]);
            return null;
        }
    }

    public RootDocImpl getRootDocImpl(String string, String string2, ModifierFilter modifierFilter, List<String> list, List<String[]> list2, boolean bl, List<String> list3, List<String> list4, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        this.docenv = DocEnv.instance(this.context);
        this.docenv.showAccess = modifierFilter;
        this.docenv.quiet = bl4;
        this.docenv.breakiterator = bl;
        this.docenv.setLocale(string);
        this.docenv.setEncoding(string2);
        this.docenv.docClasses = bl2;
        this.docenv.legacyDoclet = bl3;
        this.reader.sourceCompleter = bl2 ? null : this;
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        ListBuffer<JCTree.JCCompilationUnit> listBuffer2 = new ListBuffer<JCTree.JCCompilationUnit>();
        ListBuffer<JCTree.JCCompilationUnit> listBuffer3 = new ListBuffer<JCTree.JCCompilationUnit>();
        try {
            Object object;
            List list5;
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.docenv.fileManager;
            List list6 = list;
            while (list6.nonEmpty()) {
                list5 = (String)list6.head;
                if (!bl2 && ((String)((Object)list5)).endsWith(".java") && new File((String)((Object)list5)).exists()) {
                    object = standardJavaFileManager.getJavaFileObjects(new String[]{list5}).iterator().next();
                    this.docenv.notice("main.Loading_source_file", (String)((Object)list5));
                    JCTree.JCCompilationUnit jCCompilationUnit = this.parse((JavaFileObject)object);
                    listBuffer2.append(jCCompilationUnit);
                } else if (this.isValidPackageName((String)((Object)list5))) {
                    listBuffer = listBuffer.append((String)((Object)list5));
                } else if (((String)((Object)list5)).endsWith(".java")) {
                    this.docenv.error(null, "main.file_not_found", (String)((Object)list5));
                } else {
                    this.docenv.error(null, "main.illegal_package_name", (String)((Object)list5));
                }
                list6 = list6.tail;
            }
            if (!bl2) {
                list6 = this.searchSubPackages(list3, listBuffer, list4);
                list5 = listBuffer.toList();
                while (list5.nonEmpty()) {
                    object = (String)list5.head;
                    this.parsePackageClasses((String)object, (Iterable)list6.get(object), listBuffer3, list4);
                    list5 = list5.tail;
                }
                if (this.messager.nerrors() != 0) {
                    return null;
                }
                this.docenv.notice("main.Building_tree");
                this.enter.main(listBuffer2.toList().appendList(listBuffer3.toList()));
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        if (bl2) {
            return new RootDocImpl(this.docenv, list, list2);
        }
        return new RootDocImpl(this.docenv, this.listClasses(listBuffer2.toList()), listBuffer.toList(), list2);
    }

    boolean isValidPackageName(String string) {
        int n;
        while ((n = string.indexOf(46)) != -1) {
            if (!JavadocTool.isValidClassName(string.substring(0, n))) {
                return false;
            }
            string = string.substring(n + 1);
        }
        return JavadocTool.isValidClassName(string);
    }

    private void parsePackageClasses(String string, Iterable<JavaFileObject> iterable, ListBuffer<JCTree.JCCompilationUnit> listBuffer, List<String> list) throws IOException {
        if (list.contains(string)) {
            return;
        }
        boolean bl = false;
        this.docenv.notice("main.Loading_source_files_for_package", string);
        if (iterable == null) {
            StandardLocation standardLocation = this.docenv.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
            ListBuffer<JavaFileObject> object = new ListBuffer<JavaFileObject>();
            for (JavaFileObject javaFileObject : this.docenv.fileManager.list(standardLocation, string, EnumSet.of(JavaFileObject.Kind.SOURCE), false)) {
                String string2 = this.docenv.fileManager.inferBinaryName(standardLocation, javaFileObject);
                String string3 = this.getSimpleName(string2);
                if (!JavadocTool.isValidClassName(string3)) continue;
                object.append(javaFileObject);
            }
            iterable = object.toList();
        }
        for (JavaFileObject javaFileObject : iterable) {
            listBuffer.append(this.parse(javaFileObject));
            bl = true;
        }
        if (!bl) {
            this.messager.warning(null, "main.no_source_files_for_package", string.replace(File.separatorChar, '.'));
        }
    }

    private Map<String, List<JavaFileObject>> searchSubPackages(List<String> list, ListBuffer<String> listBuffer, List<String> list2) throws IOException {
        HashMap<String, List<JavaFileObject>> hashMap = new HashMap<String, List<JavaFileObject>>();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("", true);
        for (String string : list2) {
            hashMap2.put(string, false);
        }
        StandardLocation standardLocation = this.docenv.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        this.searchSubPackages(list, hashMap2, listBuffer, hashMap, standardLocation, EnumSet.of(JavaFileObject.Kind.SOURCE));
        return hashMap;
    }

    private void searchSubPackages(List<String> list, Map<String, Boolean> map, ListBuffer<String> listBuffer, Map<String, List<JavaFileObject>> map2, StandardLocation standardLocation, Set<JavaFileObject.Kind> set) throws IOException {
        for (String string : list) {
            if (!this.isIncluded(string, map)) continue;
            for (JavaFileObject javaFileObject : this.docenv.fileManager.list(standardLocation, string, set, true)) {
                String string2 = this.docenv.fileManager.inferBinaryName(standardLocation, javaFileObject);
                String string3 = this.getPackageName(string2);
                String string4 = this.getSimpleName(string2);
                if (!this.isIncluded(string3, map) || !JavadocTool.isValidClassName(string4)) continue;
                List<JavaFileObject> list2 = map2.get(string3);
                list2 = list2 == null ? List.of(javaFileObject) : list2.prepend(javaFileObject);
                map2.put(string3, list2);
                if (listBuffer.contains(string3)) continue;
                listBuffer.add(string3);
            }
        }
    }

    private String getPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    private String getSimpleName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(n + 1);
    }

    private boolean isIncluded(String string, Map<String, Boolean> map) {
        Boolean bl = map.get(string);
        if (bl == null) {
            bl = this.isIncluded(this.getPackageName(string), map);
            map.put(string, bl);
        }
        return bl;
    }

    private void searchSubPackage(String string, ListBuffer<String> listBuffer, List<String> list, Collection<File> collection) {
        if (list.contains(string)) {
            return;
        }
        String string2 = string.replace('.', File.separatorChar);
        boolean bl = false;
        for (File file : collection) {
            File file2 = new File(file, string2);
            String[] stringArray = file2.list();
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                if (!bl && (JavadocTool.isValidJavaSourceFile(string3) || JavadocTool.isValidJavaClassFile(string3)) && !listBuffer.contains(string)) {
                    listBuffer.append(string);
                    bl = true;
                    continue;
                }
                if (!JavadocTool.isValidClassName(string3) || !new File(file2, string3).isDirectory()) continue;
                this.searchSubPackage(string + "." + string3, listBuffer, list, collection);
            }
        }
    }

    private static boolean isValidJavaClassFile(String string) {
        if (!string.endsWith(".class")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - ".class".length());
        return JavadocTool.isValidClassName(string2);
    }

    private static boolean isValidJavaSourceFile(String string) {
        if (!string.endsWith(".java")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - ".java".length());
        return JavadocTool.isValidClassName(string2);
    }

    private static boolean surrogatesSupported() {
        try {
            boolean bl = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public static boolean isValidClassName(String string) {
        if (string.length() < 1) {
            return false;
        }
        if (string.equals("package-info")) {
            return true;
        }
        if (surrogatesSupported) {
            int n = string.codePointAt(0);
            if (!Character.isJavaIdentifierStart(n)) {
                return false;
            }
            for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    List<JCTree.JCClassDecl> listClasses(List<JCTree.JCCompilationUnit> list) {
        ListBuffer<JCTree.JCClassDecl> listBuffer = new ListBuffer<JCTree.JCClassDecl>();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            for (JCTree jCTree : jCCompilationUnit.defs) {
                if (jCTree.getTag() != 3) continue;
                listBuffer.append((JCTree.JCClassDecl)jCTree);
            }
        }
        return listBuffer.toList();
    }
}

