/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.BaseFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetDecoder;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

public abstract class BaseFileObject
implements JavaFileObject {
    protected final JavacFileManager fileManager;

    protected BaseFileObject(JavacFileManager fileManager) {
        this.fileManager = fileManager;
    }

    public abstract String getShortName();

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.openInputStream(), this.getDecoder(ignoreEncodingErrors));
    }

    protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
        throw new UnsupportedOperationException();
    }

    protected abstract String inferBinaryName(Iterable<? extends File> var1);

    protected static JavaFileObject.Kind getKind(String filename) {
        return BaseFileManager.getKind(filename);
    }

    protected static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    protected static URI createJarUri(File jarFile, String entryName) {
        URI jarURI = jarFile.toURI().normalize();
        String separator = entryName.startsWith("/") ? "!" : "!/";
        try {
            return new URI("jar:" + jarURI + separator + entryName);
        }
        catch (URISyntaxException e) {
            throw new CannotCreateUriError(jarURI + separator + entryName, e);
        }
    }

    public static String getSimpleName(FileObject fo) {
        URI uri = fo.toUri();
        String s2 = uri.getSchemeSpecificPart();
        return s2.substring(s2.lastIndexOf("/") + 1);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected static class CannotCreateUriError
    extends Error {
        private static final long serialVersionUID = 9101708840997613546L;

        public CannotCreateUriError(String value, Throwable cause) {
            super(value, cause);
        }
    }
}

