/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.ArrayTypeCodes;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaLazyReadObject;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import java.io.IOException;

public class JavaValueArray
extends JavaLazyReadObject
implements ArrayTypeCodes {
    private JavaClass clazz;
    private int data;
    private static final int SIGNATURE_MASK = 255;
    private static final int LENGTH_DIVIDER_MASK = 65280;
    private static final int LENGTH_DIVIDER_SHIFT = 8;

    private static String arrayTypeName(byte by) {
        switch (by) {
            case 66: {
                return "byte[]";
            }
            case 90: {
                return "boolean[]";
            }
            case 67: {
                return "char[]";
            }
            case 83: {
                return "short[]";
            }
            case 73: {
                return "int[]";
            }
            case 70: {
                return "float[]";
            }
            case 74: {
                return "long[]";
            }
            case 68: {
                return "double[]";
            }
        }
        throw new RuntimeException("invalid array element sig: " + by);
    }

    private static int elementSize(byte by) {
        switch (by) {
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        throw new RuntimeException("invalid array element type: " + by);
    }

    @Override
    protected final int readValueLength() throws IOException {
        JavaClass javaClass = this.getClazz();
        ReadBuffer readBuffer = javaClass.getReadBuffer();
        int n = javaClass.getIdentifierSize();
        long l = this.getOffset() + (long)n + 4L;
        int n2 = readBuffer.getInt(l);
        byte by = readBuffer.getByte(l + 4L);
        return n2 * JavaValueArray.elementSize(by);
    }

    @Override
    protected final byte[] readValue() throws IOException {
        JavaClass javaClass = this.getClazz();
        ReadBuffer readBuffer = javaClass.getReadBuffer();
        int n = javaClass.getIdentifierSize();
        long l = this.getOffset() + (long)n + 4L;
        int n2 = readBuffer.getInt(l);
        byte by = readBuffer.getByte(l + 4L);
        if (n2 == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2 *= JavaValueArray.elementSize(by)];
        readBuffer.get(l + 5L, byArray);
        return byArray;
    }

    public JavaValueArray(byte by, long l) {
        super(l);
        this.data = by & 0xFF;
    }

    @Override
    public JavaClass getClazz() {
        return this.clazz;
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor javaHeapObjectVisitor) {
        super.visitReferencedObjects(javaHeapObjectVisitor);
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.clazz instanceof JavaClass) {
            return;
        }
        byte by = this.getElementType();
        this.clazz = snapshot.findClass(JavaValueArray.arrayTypeName(by));
        if (this.clazz == null) {
            this.clazz = snapshot.getArrayClass("" + (char)by);
        }
        this.getClazz().addInstance(this);
        super.resolve(snapshot);
    }

    public int getLength() {
        int n = (this.data & 0xFF00) >>> 8;
        if (n == 0) {
            byte by = this.getElementType();
            switch (by) {
                case 66: 
                case 90: {
                    n = 1;
                    break;
                }
                case 67: 
                case 83: {
                    n = 2;
                    break;
                }
                case 70: 
                case 73: {
                    n = 4;
                    break;
                }
                case 68: 
                case 74: {
                    n = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown primitive type: " + by);
                }
            }
            this.data |= n << 8;
        }
        return this.getValueLength() / n;
    }

    public Object getElements() {
        int n = this.getLength();
        byte by = this.getElementType();
        byte[] byArray = this.getValue();
        int n2 = 0;
        switch (by) {
            case 90: {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = JavaValueArray.booleanAt(n2, byArray);
                    ++n2;
                }
                return blArray;
            }
            case 66: {
                byte[] byArray2 = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray2[i] = JavaValueArray.byteAt(n2, byArray);
                    ++n2;
                }
                return byArray2;
            }
            case 67: {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = JavaValueArray.charAt(n2, byArray);
                    n2 += 2;
                }
                return cArray;
            }
            case 83: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = JavaValueArray.shortAt(n2, byArray);
                    n2 += 2;
                }
                return sArray;
            }
            case 73: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = JavaValueArray.intAt(n2, byArray);
                    n2 += 4;
                }
                return nArray;
            }
            case 74: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = JavaValueArray.longAt(n2, byArray);
                    n2 += 8;
                }
                return lArray;
            }
            case 70: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = JavaValueArray.floatAt(n2, byArray);
                    n2 += 4;
                }
                return fArray;
            }
            case 68: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = JavaValueArray.doubleAt(n2, byArray);
                    n2 += 8;
                }
                return dArray;
            }
        }
        throw new RuntimeException("unknown primitive type?");
    }

    public byte getElementType() {
        return (byte)(this.data & 0xFF);
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    private void requireType(char c) {
        if (this.getElementType() != c) {
            throw new RuntimeException("not of type : " + c);
        }
    }

    public boolean getBooleanAt(int n) {
        this.checkIndex(n);
        this.requireType('Z');
        return JavaValueArray.booleanAt(n, this.getValue());
    }

    public byte getByteAt(int n) {
        this.checkIndex(n);
        this.requireType('B');
        return JavaValueArray.byteAt(n, this.getValue());
    }

    public char getCharAt(int n) {
        this.checkIndex(n);
        this.requireType('C');
        return JavaValueArray.charAt(n << 1, this.getValue());
    }

    public short getShortAt(int n) {
        this.checkIndex(n);
        this.requireType('S');
        return JavaValueArray.shortAt(n << 1, this.getValue());
    }

    public int getIntAt(int n) {
        this.checkIndex(n);
        this.requireType('I');
        return JavaValueArray.intAt(n << 2, this.getValue());
    }

    public long getLongAt(int n) {
        this.checkIndex(n);
        this.requireType('J');
        return JavaValueArray.longAt(n << 3, this.getValue());
    }

    public float getFloatAt(int n) {
        this.checkIndex(n);
        this.requireType('F');
        return JavaValueArray.floatAt(n << 2, this.getValue());
    }

    public double getDoubleAt(int n) {
        this.checkIndex(n);
        this.requireType('D');
        return JavaValueArray.doubleAt(n << 3, this.getValue());
    }

    public String valueString() {
        return this.valueString(true);
    }

    public String valueString(boolean bl) {
        StringBuffer stringBuffer;
        byte[] byArray = this.getValue();
        int n = byArray.length;
        byte by = this.getElementType();
        if (by == 67) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; i += 2) {
                char c = JavaValueArray.charAt(i, byArray);
                stringBuffer.append(c);
            }
        } else {
            int n2 = 8;
            if (bl) {
                n2 = 1000;
            }
            stringBuffer = new StringBuffer("{");
            int n3 = 0;
            int n4 = 0;
            block10: while (n4 < byArray.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                if (n3 >= n2) {
                    stringBuffer.append("... ");
                    break;
                }
                ++n3;
                switch (by) {
                    case 90: {
                        boolean bl2 = JavaValueArray.booleanAt(n4, byArray);
                        if (bl2) {
                            stringBuffer.append("true");
                        } else {
                            stringBuffer.append("false");
                        }
                        ++n4;
                        continue block10;
                    }
                    case 66: {
                        int n5 = 0xFF & JavaValueArray.byteAt(n4, byArray);
                        stringBuffer.append("0x" + Integer.toString(n5, 16));
                        ++n4;
                        continue block10;
                    }
                    case 83: {
                        short s2 = JavaValueArray.shortAt(n4, byArray);
                        n4 += 2;
                        stringBuffer.append("" + s2);
                        continue block10;
                    }
                    case 73: {
                        int n6 = JavaValueArray.intAt(n4, byArray);
                        n4 += 4;
                        stringBuffer.append("" + n6);
                        continue block10;
                    }
                    case 74: {
                        long l = JavaValueArray.longAt(n4, byArray);
                        stringBuffer.append("" + l);
                        n4 += 8;
                        continue block10;
                    }
                    case 70: {
                        float f = JavaValueArray.floatAt(n4, byArray);
                        stringBuffer.append("" + f);
                        n4 += 4;
                        continue block10;
                    }
                    case 68: {
                        double d = JavaValueArray.doubleAt(n4, byArray);
                        stringBuffer.append("" + d);
                        n4 += 8;
                        continue block10;
                    }
                }
                throw new RuntimeException("unknown primitive type?");
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

