/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Group {
    private Map<String, String> regExpGroupMap = new HashMap<String, String>();
    private List<String> sortedRegExpList = new ArrayList<String>();
    private List<String> groupList = new ArrayList<String>();
    private Map<String, String> pkgNameGroupMap = new HashMap<String, String>();
    private final Configuration configuration;

    public Group(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean checkPackageGroups(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (this.groupList.contains(string)) {
            this.configuration.message.warning("doclet.Groupname_already_used", string);
            return false;
        }
        this.groupList.add(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 0) {
                this.configuration.message.warning("doclet.Error_in_packagelist", string, string2);
                return false;
            }
            if (string3.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, string3 = string3.substring(0, string3.length() - 1))) {
                    return false;
                }
                this.regExpGroupMap.put(string3, string);
                this.sortedRegExpList.add(string3);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, string3)) {
                return false;
            }
            this.pkgNameGroupMap.put(string3, string);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map<String, ?> map, String string) {
        if (map.containsKey(string)) {
            this.configuration.message.error("doclet.Same_package_name_used", string);
            return true;
        }
        return false;
    }

    public Map<String, List<PackageDoc>> groupPackages(PackageDoc[] packageDocArray) {
        String string;
        HashMap<String, List<PackageDoc>> hashMap = new HashMap<String, List<PackageDoc>>();
        String string2 = string = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.configuration.message.getText("doclet.Packages", new Object[0]) : this.configuration.message.getText("doclet.Other_Packages", new Object[0]);
        if (!this.groupList.contains(string)) {
            this.groupList.add(string);
        }
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageDoc packageDoc = packageDocArray[i];
            String string3 = packageDoc.name();
            String string4 = this.pkgNameGroupMap.get(string3);
            if (string4 == null) {
                string4 = this.regExpGroupName(string3);
            }
            if (string4 == null) {
                string4 = string;
            }
            this.getPkgList(hashMap, string4).add(packageDoc);
        }
        return hashMap;
    }

    String regExpGroupName(String string) {
        for (int i = 0; i < this.sortedRegExpList.size(); ++i) {
            String string2 = this.sortedRegExpList.get(i);
            if (!string.startsWith(string2)) continue;
            return this.regExpGroupMap.get(string2);
        }
        return null;
    }

    List<PackageDoc> getPkgList(Map<String, List<PackageDoc>> map, String string) {
        List<PackageDoc> list = map.get(string);
        if (list == null) {
            list = new ArrayList<PackageDoc>();
            map.put(string, list);
        }
        return list;
    }

    public List<String> getGroupList() {
        return this.groupList;
    }

    private static class MapKeyComparator
    implements Comparator<String> {
        private MapKeyComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string2.length() - string.length();
        }
    }
}

