/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.PackageSummaryBuilder;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set<ClassDoc> documentedClasses;
    public static final String OUTPUT_FILE_NAME = "package-frame.html";

    public PackageFrameWriter(ConfigurationImpl configurationImpl, PackageDoc packageDoc) throws IOException {
        super(configurationImpl, DirectoryManager.getDirectoryPath(packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath(packageDoc));
        this.packageDoc = packageDoc;
        if (configurationImpl.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configurationImpl.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packageFrameWriter = new PackageFrameWriter(configurationImpl, packageDoc);
            String string = Util.getPackageName(packageDoc);
            HtmlTree htmlTree = packageFrameWriter.getBody(false, packageFrameWriter.getWindowTitle(string));
            RawHtml rawHtml = new RawHtml(string);
            HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packageFrameWriter.getTargetPackageLink(packageDoc, "classFrame", rawHtml));
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DIV);
            htmlTree3.addStyle(HtmlStyle.indexContainer);
            packageFrameWriter.addClassListing(htmlTree3);
            ((Content)htmlTree).addContent(htmlTree3);
            packageFrameWriter.printHtmlDocument(configurationImpl.metakeywords.getMetaKeywords(packageDoc), false, htmlTree);
            packageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), OUTPUT_FILE_NAME);
            throw new DocletAbortException();
        }
    }

    protected void addClassListing(Content content) {
        Configuration configuration = this.configuration();
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), content);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), content);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), content);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), content);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), content);
            this.addClassKindListing(this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), content);
        } else {
            String string = Util.getPackageName(this.packageDoc);
            this.addClassKindListing(configuration.classDocCatalog.interfaces(string), this.getResource("doclet.Interfaces"), content);
            this.addClassKindListing(configuration.classDocCatalog.ordinaryClasses(string), this.getResource("doclet.Classes"), content);
            this.addClassKindListing(configuration.classDocCatalog.enums(string), this.getResource("doclet.Enums"), content);
            this.addClassKindListing(configuration.classDocCatalog.exceptions(string), this.getResource("doclet.Exceptions"), content);
            this.addClassKindListing(configuration.classDocCatalog.errors(string), this.getResource("doclet.Errors"), content);
            this.addClassKindListing(configuration.classDocCatalog.annotationTypes(string), this.getResource("doclet.AnnotationTypes"), content);
        }
    }

    protected void addClassKindListing(ClassDoc[] classDocArray, Content content, Content content2) {
        if ((classDocArray = PackageSummaryBuilder.filterOutPrivateClasses(classDocArray)).length > 0) {
            Arrays.sort(classDocArray);
            boolean bl = false;
            HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
            htmlTree.addAttr(HtmlAttr.TITLE, content.toString());
            for (int i = 0; i < classDocArray.length; ++i) {
                Content content3;
                if (this.documentedClasses != null && !this.documentedClasses.contains(classDocArray[i]) || !Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                if (!bl) {
                    content3 = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, content);
                    content2.addContent(content3);
                    bl = true;
                }
                content3 = new RawHtml(this.getLink(new LinkInfoImpl(13, classDocArray[i], classDocArray[i].isInterface() ? this.italicsText(classDocArray[i].name()) : classDocArray[i].name(), "classFrame")));
                HtmlTree htmlTree2 = HtmlTree.LI(content3);
                htmlTree.addContent(htmlTree2);
            }
            content2.addContent(htmlTree);
        }
    }
}

