/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.io.ASTPath;

public class IntersectionTypeLocationCriterion
implements Criterion {
    private final int typeIndex;

    public IntersectionTypeLocationCriterion(RelativeLocation loc) {
        this.typeIndex = loc.type_index;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        Tree.Kind kind;
        Tree parent;
        TreePath parentPath = path.getParentPath();
        if (parentPath != null && (parent = parentPath.getLeaf()).getKind() == Tree.Kind.INTERSECTION_TYPE) {
            IntersectionTypeTree itt = (IntersectionTypeTree)parent;
            List<? extends Tree> bounds = itt.getBounds();
            Tree leaf = path.getLeaf();
            if (this.typeIndex < bounds.size() && leaf == bounds.get(this.typeIndex)) {
                return true;
            }
        }
        if (ASTPath.isTypeKind(kind = path.getLeaf().getKind()) || kind == Tree.Kind.MEMBER_SELECT) {
            return this.isSatisfiedBy(path.getParentPath());
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.INTERSECT_LOCATION;
    }

    public String toString() {
        return "IntersectionTypeLocation: at type index: " + this.typeIndex;
    }
}

