/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.ASTPathCriterion;
import annotator.find.CastInsertion;
import annotator.find.CloseParenthesisInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.Insertion;
import annotator.find.NewInsertion;
import annotator.find.TypedInsertion;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.io.ASTIndex;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.ASTRecord;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class Insertions
implements Iterable<Insertion> {
    private Map<String, Map<String, Set<Insertion>>> store = new HashMap<String, Map<String, Set<Insertion>>>();
    private int size = 0;
    private static final Comparator<Insertion> byASTRecord = new Comparator<Insertion>(){

        @Override
        public int compare(Insertion o1, Insertion o2) {
            ASTRecord r2;
            Criteria crit1 = o1.getCriteria();
            Criteria crit2 = o2.getCriteria();
            ASTPath p1 = crit1.getASTPath();
            ASTPath p2 = crit2.getASTPath();
            ASTRecord r1 = new ASTRecord(null, crit1.getClassName(), crit1.getMethodName(), crit1.getFieldName(), p1 == null ? ASTPath.empty() : p1);
            int cmp = r1.compareTo(r2 = new ASTRecord(null, crit2.getClassName(), crit2.getMethodName(), crit2.getFieldName(), p2 == null ? ASTPath.empty() : p2));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(Insertions.kindLevel(o2), Insertions.kindLevel(o1));
            if (cmp != 0) {
                return cmp;
            }
            cmp = o1.toString().compareTo(o2.toString());
            return cmp;
        }
    };

    public Set<Insertion> forClass(CompilationUnitTree cut, String qualifiedClassName) {
        LinkedHashSet<Insertion> set = new LinkedHashSet<Insertion>();
        this.forClass(cut, qualifiedClassName, set);
        return set;
    }

    public Set<Insertion> forOuterClass(CompilationUnitTree cut, String qualifiedOuterClassName) {
        Map<String, Set<Insertion>> map = this.store.get(qualifiedOuterClassName);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        if (Main.temporaryDebug) {
            System.out.printf("forOuterClass(%s): map = %s%n", qualifiedOuterClassName, map);
        }
        LinkedHashSet<Insertion> set = new LinkedHashSet<Insertion>();
        for (String key : map.keySet()) {
            String qualifiedClassName = qualifiedOuterClassName + key;
            this.forClass(cut, qualifiedClassName, set);
        }
        return set;
    }

    private void forClass(CompilationUnitTree cut, String qualifiedClassName, Set<Insertion> result) {
        String outerClass;
        Map<String, Set<Insertion>> map;
        if (Main.temporaryDebug) {
            System.out.printf("calling forClass(cut, %s, set of size %d)%n", qualifiedClassName, result.size());
        }
        if ((map = this.store.get(outerClass = Insertions.outerClassName(qualifiedClassName))) != null) {
            TreeSet<Insertion> set = new TreeSet<Insertion>(byASTRecord);
            set.addAll((Collection<Insertion>)map.get(Insertions.innerClassName(qualifiedClassName)));
            if (Main.temporaryDebug) {
                System.out.println("organizeTypedInsertions argument set size = " + set.size());
            }
            Set<Insertion> organized = this.organizeTypedInsertions(cut, qualifiedClassName, set);
            if (Main.temporaryDebug) {
                System.out.println("organizeTypedInsertions result set size = " + organized.size());
            }
            result.addAll(organized);
        }
    }

    public void add(Insertion ins) {
        Set<Insertion> set;
        String innerClass;
        String outerClass;
        InClassCriterion icc = ins.getCriteria().getInClass();
        if (icc == null) {
            outerClass = "";
            innerClass = "";
        } else {
            outerClass = Insertions.outerClassName(icc.className);
            innerClass = Insertions.innerClassName(icc.className);
        }
        Map<String, Set<Insertion>> map = this.store.get(outerClass);
        if (map == null) {
            map = new HashMap<String, Set<Insertion>>();
            this.store.put(outerClass, map);
        }
        if ((set = map.get(innerClass)) == null) {
            set = new LinkedHashSet<Insertion>();
            map.put(innerClass, set);
        }
        this.size -= set.size();
        set.add(ins);
        this.size += set.size();
    }

    public void addAll(Collection<? extends Insertion> c) {
        for (Insertion insertion : c) {
            this.add(insertion);
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Insertion> iterator() {
        return new Iterator<Insertion>(){
            private Iterator<Map<String, Set<Insertion>>> miter;
            private Iterator<Set<Insertion>> siter;
            private Iterator<Insertion> iiter;
            {
                this.miter = Insertions.this.store.values().iterator();
                this.siter = Collections.emptySet().iterator();
                this.iiter = Collections.emptySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.iiter.hasNext()) {
                    return true;
                }
                if (this.siter.hasNext()) {
                    this.iiter = this.siter.next().iterator();
                    return this.hasNext();
                }
                if (this.miter.hasNext()) {
                    this.siter = this.miter.next().values().iterator();
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public Insertion next() {
                if (this.hasNext()) {
                    return this.iiter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public java.util.List<Insertion> toList() {
        ArrayList<Insertion> list = new ArrayList<Insertion>(this.size);
        for (Insertion ins : this) {
            list.add(ins);
        }
        return list;
    }

    private Set<Insertion> organizeTypedInsertions(CompilationUnitTree cut, String className, Collection<Insertion> insertions) {
        Criteria criteria;
        HashMap<ASTRecord, TypedInsertion> outerInsertions = new HashMap<ASTRecord, TypedInsertion>();
        LinkedHashSet innerInsertions = new LinkedHashSet();
        ArrayList<Insertion> innerInsertionsList = new ArrayList<Insertion>();
        LinkedHashSet<Insertion> organized = new LinkedHashSet<Insertion>();
        if (Main.temporaryDebug) {
            System.out.printf("organizeTypedInsertions (1): insertions.size()= %d%n", insertions.size());
        }
        for (Insertion ins : insertions) {
            ASTPath parentPath;
            Tree node;
            if (Main.temporaryDebug) {
                System.out.printf("Considering insertion %s (isInserted=%s)%n", ins, ins.isInserted());
            }
            if (ins.isInserted()) continue;
            criteria = ins.getCriteria();
            GenericArrayLocationCriterion galc = criteria.getGenericArrayLocation();
            ASTPath p = criteria.getASTPath();
            if (p == null || p.isEmpty() || galc != null && !galc.getLocation().isEmpty() || ins instanceof CastInsertion || ins instanceof CloseParenthesisInsertion) {
                if (Main.temporaryDebug) {
                    System.out.printf("Adding to organized (size %d): %s%n", organized.size(), ins);
                }
                organized.add(ins);
                if (!Main.temporaryDebug) continue;
                System.out.printf("  organized now has size %d%n", organized.size());
                continue;
            }
            ASTRecord rec = new ASTRecord(cut, criteria.getClassName(), criteria.getMethodName(), criteria.getFieldName(), p);
            ASTPath.ASTEntry entry = rec.astPath.getLast();
            node = entry.getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type") && entry.getArgument() == 0 ? ((node = ASTIndex.getNode(cut, rec.replacePath(parentPath = rec.astPath.getParentPath()))) instanceof JCTree.JCNewArray ? TypeTree.fromJavacType(((JCTree.JCNewArray)node).type) : null) : ASTIndex.getNode(cut, rec);
            if (ins instanceof TypedInsertion) {
                TypedInsertion tins = (TypedInsertion)outerInsertions.get(rec);
                if (ins instanceof NewInsertion) {
                    NewInsertion nins = (NewInsertion)ins;
                    if (entry.getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type")) {
                        int a = entry.getArgument();
                        ArrayList loc0 = new ArrayList(a);
                        ASTRecord rec0 = null;
                        if (a == 0) {
                            rec0 = rec.replacePath(p.getParentPath());
                            Tree t = ASTIndex.getNode(cut, rec0);
                            if (t == null || t.toString().startsWith("{")) {
                                rec0 = null;
                            } else {
                                rec = rec0;
                                rec0 = rec.extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        } else if (node != null && !nins.getInnerTypeInsertions().isEmpty()) {
                            if (node.getKind() == Tree.Kind.IDENTIFIER) {
                                node = ASTIndex.getNode(cut, rec.replacePath(p.getParentPath()));
                            }
                            if (!(node.getKind() != Tree.Kind.NEW_ARRAY && node.getKind() != Tree.Kind.ARRAY_TYPE || node.toString().startsWith("{"))) {
                                rec = rec.replacePath(p.getParentPath());
                                Collections.fill(loc0, TypeAnnotationPosition.TypePathEntry.ARRAY);
                                rec0 = rec.extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        }
                        if (rec0 != null) {
                            for (Insertion inner : nins.getInnerTypeInsertions()) {
                                Criteria icriteria = inner.getCriteria();
                                GenericArrayLocationCriterion igalc = icriteria.getGenericArrayLocation();
                                if (igalc == null) continue;
                                int b = igalc.getLocation().size();
                                ArrayList<TypeAnnotationPosition.TypePathEntry> loc = new ArrayList<TypeAnnotationPosition.TypePathEntry>(a + b);
                                loc.addAll(loc0);
                                loc.addAll(igalc.getLocation());
                                ASTRecord rec1 = this.extendToInnerType(rec0, loc, node);
                                icriteria.add(new GenericArrayLocationCriterion());
                                icriteria.add(new ASTPathCriterion(rec1.astPath));
                                inner.setInserted(false);
                                if (Main.temporaryDebug) {
                                    System.out.printf("Adding to organized (size %d): %s%n", organized.size(), ins);
                                }
                                organized.add(inner);
                                if (!Main.temporaryDebug) continue;
                                System.out.printf("  organized now has size %d%n", organized.size());
                            }
                            nins.getInnerTypeInsertions().clear();
                        }
                    }
                }
                if (tins == null) {
                    outerInsertions.put(rec, (TypedInsertion)ins);
                    continue;
                }
                if (!tins.getType().equals(((TypedInsertion)ins).getType())) continue;
                this.mergeTypedInsertions(tins, (TypedInsertion)ins);
                continue;
            }
            int d = this.newArrayInnerTypeDepth(p);
            if (d > 0) {
                ASTPath temp = p;
                while (!(temp.isEmpty() || node != null && node.getKind() == Tree.Kind.NEW_ARRAY)) {
                    temp = temp.getParentPath();
                    node = ASTIndex.getNode(cut, rec.replacePath(temp));
                }
                if (node == null) {
                    throw new Error("node == null case not yet implemented");
                }
                temp = temp.extend(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                if (node.toString().startsWith("{")) {
                    TypedInsertion tins = (TypedInsertion)outerInsertions.get(rec.replacePath(temp));
                    if (tins == null) {
                        throw new Error("tins == null case not yet implemented");
                    }
                    tins.getInnerTypeInsertions().add(ins);
                    ins.setInserted(true);
                } else {
                    java.util.List<TypeAnnotationPosition.TypePathEntry> loc;
                    java.util.List<? extends ExpressionTree> dims = ((NewArrayTree)node).getDimensions();
                    ASTRecord irec = rec.replacePath(p.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", 0);
                    GenericArrayLocationCriterion igalc = criteria.getGenericArrayLocation();
                    for (int i = 0; i < d; ++i) {
                        irec = irec.extend(Tree.Kind.ARRAY_TYPE, "type");
                    }
                    if (igalc != null && !(loc = igalc.getLocation()).isEmpty()) {
                        try {
                            Tree dim = dims.get(d - 1);
                            irec = this.extendToInnerType(irec, loc, dim);
                            criteria.add(new ASTPathCriterion(irec.astPath));
                            criteria.add(new GenericArrayLocationCriterion());
                        }
                        catch (RuntimeException dim) {
                            // empty catch block
                        }
                    }
                }
            }
            innerInsertionsList.add(ins);
        }
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (1) = %d%n", organized.size());
        }
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertionsList size (1) = %d%n", innerInsertionsList.size());
        }
        Collections.sort(innerInsertionsList, byASTRecord);
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertionsList size (2) = %d%n", innerInsertionsList.size());
        }
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertions size (1) = %d%n", innerInsertions.size());
        }
        innerInsertions.addAll(innerInsertionsList);
        if (Main.temporaryDebug) {
            System.out.printf("innerInsertions size (2) = %d%n", innerInsertions.size());
        }
        block21: for (Insertion ins : innerInsertions) {
            ASTPath.ASTEntry entry;
            int i;
            Tree node;
            Tree.Kind kind;
            ASTRecord rec;
            criteria = ins.getCriteria();
            String methodName = criteria.getMethodName();
            String fieldName = criteria.getFieldName();
            ASTPath localTypePath = criteria.getASTPath();
            ArrayList<TypeAnnotationPosition.TypePathEntry> tpes = new ArrayList<TypeAnnotationPosition.TypePathEntry>();
            if (localTypePath == null) {
                organized.add(ins);
                continue;
            }
            ArrayDeque<ASTPath> astack = new ArrayDeque<ASTPath>(localTypePath.size());
            ASTPath topLevelTypePath = localTypePath;
            do {
                astack.push(topLevelTypePath);
            } while (!(topLevelTypePath = topLevelTypePath.getParentPath()).isEmpty());
            do {
                topLevelTypePath = (ASTPath)astack.pop();
                kind = topLevelTypePath.getLast().getTreeKind();
                rec = new ASTRecord(cut, className, methodName, fieldName, topLevelTypePath);
            } while (!astack.isEmpty() && !outerInsertions.containsKey(rec));
            TypedInsertion tins = (TypedInsertion)outerInsertions.get(rec);
            TreePath path = ASTIndex.getTreePath(cut, rec);
            Tree tree = node = path == null ? null : path.getLeaf();
            if (node == null && topLevelTypePath.isEmpty()) {
                organized.add(ins);
                continue;
            }
            if (tins == null) {
                GenericArrayLocationCriterion galc = criteria.getGenericArrayLocation();
                if (node == null) {
                    organized.add(ins);
                    continue;
                }
                Tree t = path.getLeaf();
                switch (t.getKind()) {
                    case NEW_ARRAY: {
                        int d = 0;
                        ASTPath.ASTEntry e = localTypePath.getLast();
                        java.util.List<TypeAnnotationPosition.TypePathEntry> loc = null;
                        ArrayList<Insertion> inners = new ArrayList<Insertion>();
                        scenelib.type.Type type = TypeTree.javacTypeToType(((JCTree.JCNewArray)t).type);
                        if (e.getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            d += e.getArgument();
                        }
                        if (galc != null) {
                            loc = galc.getLocation();
                            int n = loc.size();
                            while (--n >= 0 && loc.get((int)n).tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++d;
                            }
                            loc = n < 0 ? null : loc.subList(0, ++n);
                        }
                        criteria.add(new ASTPathCriterion(rec.astPath.getParentPath().extendNewArray(d)));
                        criteria.add(loc == null || loc.isEmpty() ? new GenericArrayLocationCriterion() : new GenericArrayLocationCriterion(new InnerTypeLocation(loc)));
                        inners.add(ins);
                        tins = new NewInsertion(type, criteria, inners);
                        tins.setInserted(true);
                        outerInsertions.put(rec, tins);
                        break;
                    }
                }
                path = path.getParentPath();
            }
            if (node == null) {
                ASTPath ap = topLevelTypePath;
                if (!ap.isEmpty()) {
                    while ((node = ASTIndex.getNode(cut, rec.replacePath(ap = ap.getParentPath()))) == null && !ap.isEmpty()) {
                    }
                }
                if (node == null) {
                    organized.add(ins);
                    continue;
                }
                Symbol.ClassSymbol csym = null;
                switch (tins.getKind()) {
                    case CONSTRUCTOR: {
                        if (node instanceof JCTree.JCMethodDecl) {
                            Symbol.MethodSymbol msym = ((JCTree.JCMethodDecl)node).sym;
                            csym = (Symbol.ClassSymbol)msym.owner;
                            node = TypeTree.fromJavacType(csym.type);
                            break;
                        }
                        if (node instanceof JCTree.JCClassDecl) {
                            csym = ((JCTree.JCClassDecl)node).sym;
                            if (csym.owner instanceof Symbol.ClassSymbol) {
                                csym = (Symbol.ClassSymbol)csym.owner;
                                node = TypeTree.fromJavacType(csym.type);
                                break;
                            }
                        }
                        throw new RuntimeException();
                    }
                    case NEW: {
                        if (node instanceof JCTree.JCNewArray) {
                            if (node.toString().startsWith("{")) {
                                node = TypeTree.fromJavacType(((JCTree.JCNewArray)node).type);
                                break;
                            }
                            organized.add(ins);
                            continue block21;
                        }
                        throw new RuntimeException();
                    }
                    case RECEIVER: {
                        if (node instanceof JCTree.JCMethodDecl) {
                            JCTree.JCMethodDecl jmd = (JCTree.JCMethodDecl)node;
                            csym = (Symbol.ClassSymbol)jmd.sym.owner;
                            if ("<init>".equals(jmd.name.toString())) {
                                csym = (Symbol.ClassSymbol)csym.owner;
                            }
                        } else if (node instanceof JCTree.JCClassDecl) {
                            csym = ((JCTree.JCClassDecl)node).sym;
                        }
                        if (csym != null) {
                            node = TypeTree.fromJavacType(csym.type);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            int n = localTypePath.size();
            int actualDepth = 0;
            int expectedDepth = 0;
            for (i = topLevelTypePath.size(); i < n && ((kind = (entry = (ASTPath.ASTEntry)localTypePath.get(i)).getTreeKind()) == Tree.Kind.METHOD || kind == Tree.Kind.VARIABLE); ++i) {
            }
            while (i < n) {
                entry = (ASTPath.ASTEntry)localTypePath.get(i);
                rec = rec.extend(entry);
                kind = entry.getTreeKind();
                while (node.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    node = ((AnnotatedTypeTree)node).getUnderlyingType();
                }
                if (expectedDepth == 0) {
                    expectedDepth = this.localDepth(node);
                }
                switch (kind) {
                    case ARRAY_TYPE: {
                        if (expectedDepth == 0 && node.getKind() == kind) {
                            node = ((ArrayTypeTree)node).getType();
                            while (--actualDepth >= 0) {
                                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case MEMBER_SELECT: {
                        if (--expectedDepth >= 0) {
                            node = ((MemberSelectTree)node).getExpression();
                            ++actualDepth;
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case NEW_ARRAY: {
                        assert (tpes.isEmpty());
                        topLevelTypePath = topLevelTypePath.add(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                        if (expectedDepth == 0 && node.getKind() == kind) {
                            if (node instanceof JCTree.JCNewArray) {
                                int arg = entry.getArgument();
                                if (arg > 0) {
                                    node = ((JCTree.JCNewArray)node).elemtype;
                                    tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    while (--arg > 0 && node instanceof JCTree.JCArrayTypeTree) {
                                        node = ((JCTree.JCArrayTypeTree)node).elemtype;
                                        tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    }
                                    if (arg <= 0) break;
                                    throw new RuntimeException();
                                }
                                node = TypeTree.fromJavacType(((JCTree.JCNewArray)node).type);
                                break;
                            }
                            throw new RuntimeException("NYI");
                        }
                        throw new RuntimeException();
                    }
                    case PARAMETERIZED_TYPE: {
                        if (node.getKind() == kind) {
                            ParameterizedTypeTree ptt = (ParameterizedTypeTree)node;
                            if (entry.childSelectorIs("type")) {
                                node = ptt.getType();
                                break;
                            }
                            if (expectedDepth == 0 && entry.childSelectorIs("typeArgument")) {
                                java.util.List<? extends Tree> typeArgs = ptt.getTypeArguments();
                                int j = entry.getArgument();
                                if (j >= 0 && j < typeArgs.size()) {
                                    actualDepth = 0;
                                    expectedDepth = this.localDepth(ptt.getType());
                                    while (--expectedDepth >= 0) {
                                        tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                                    }
                                    node = typeArgs.get(j);
                                    tpes.add(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, j));
                                    break;
                                }
                            }
                        }
                        throw new RuntimeException();
                    }
                    case UNBOUNDED_WILDCARD: {
                        if (!(!ASTPath.isWildcard(node.getKind()) || expectedDepth != 0 || i >= 1 && ((ASTPath.ASTEntry)localTypePath.get(i - 1)).getTreeKind() == Tree.Kind.INSTANCE_OF || i >= 2 && ((ASTPath.ASTEntry)localTypePath.get(i - 2)).getTreeKind() == Tree.Kind.ARRAY_TYPE)) {
                            while (--actualDepth >= 0) {
                                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            tpes.add(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        node = ASTIndex.getNode(cut, rec);
                    }
                }
                ++i;
            }
            while (--actualDepth >= 0) {
                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            organized.add(ins);
            if (tpes.isEmpty()) continue;
            criteria.add(new ASTPathCriterion(topLevelTypePath));
            criteria.add(new GenericArrayLocationCriterion(new InnerTypeLocation(tpes)));
            tins.getInnerTypeInsertions().add(ins);
        }
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (2) = %d%n", organized.size());
        }
        organized.addAll(outerInsertions.values());
        if (Main.temporaryDebug) {
            System.out.printf("organized.size() (3) = %d%n", organized.size());
        }
        return organized;
    }

    private int newArrayInnerTypeDepth(ASTPath path) {
        int result = 0;
        while (!path.isEmpty()) {
            ASTPath.ASTEntry entry = path.getLast();
            switch (entry.getTreeKind()) {
                case MEMBER_SELECT: 
                case PARAMETERIZED_TYPE: 
                case UNBOUNDED_WILDCARD: 
                case ANNOTATED_TYPE: {
                    result = 0;
                    break;
                }
                case ARRAY_TYPE: {
                    ++result;
                    break;
                }
                case NEW_ARRAY: {
                    if (entry.childSelectorIs("type") && entry.hasArgument()) {
                        result += entry.getArgument();
                    }
                    return result;
                }
                default: {
                    return 0;
                }
            }
            path = path.getParentPath();
        }
        return 0;
    }

    private ASTRecord extendToInnerType(ASTRecord rec, java.util.List<TypeAnnotationPosition.TypePathEntry> loc) {
        ASTRecord r = rec;
        Iterator<TypeAnnotationPosition.TypePathEntry> iter = loc.iterator();
        int depth = 0;
        block6: while (iter.hasNext()) {
            TypeAnnotationPosition.TypePathEntry tpe = iter.next();
            switch (tpe.tag) {
                case ARRAY: {
                    while (depth-- > 0) {
                        r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    r = r.extend(Tree.Kind.ARRAY_TYPE, "type");
                    continue block6;
                }
                case INNER_TYPE: {
                    ++depth;
                    continue block6;
                }
                case TYPE_ARGUMENT: {
                    depth = 0;
                    r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.arg);
                    continue block6;
                }
                case WILDCARD: {
                    while (depth-- > 0) {
                        r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    r = r.extend(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    continue block6;
                }
            }
            throw new RuntimeException();
        }
        while (depth-- > 0) {
            r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
        }
        return r;
    }

    private ASTRecord extendToInnerType(ASTRecord rec, java.util.List<TypeAnnotationPosition.TypePathEntry> loc, Tree node) {
        ASTRecord r = rec;
        Tree t = node;
        Iterator<TypeAnnotationPosition.TypePathEntry> iter = loc.iterator();
        TypeAnnotationPosition.TypePathEntry tpe = iter.next();
        block8: while (true) {
            int d = this.localDepth(node);
            switch (t.getKind()) {
                case ANNOTATED_TYPE: {
                    r = r.extend(Tree.Kind.ANNOTATED_TYPE, "type");
                    t = ((JCTree.JCAnnotatedType)t).getUnderlyingType();
                    break;
                }
                case ARRAY_TYPE: {
                    if (d == 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                        ASTPath.ASTEntry e;
                        int a = 0;
                        if (!r.astPath.isEmpty() && (e = r.astPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY && e.childSelectorIs("type")) {
                            a = 1 + e.getArgument();
                        }
                        r = a > 0 ? r.replacePath(r.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", a) : r.extend(Tree.Kind.ARRAY_TYPE, "type");
                        t = ((ArrayTypeTree)t).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case MEMBER_SELECT: {
                    if (d > 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        Tree temp = t;
                        do {
                            temp = ((JCTree.JCFieldAccess)temp).getExpression();
                            if (!iter.hasNext()) {
                                do {
                                    r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--d > 0);
                                return r;
                            }
                            tpe = iter.next();
                            if (--d == 0) continue block8;
                        } while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case NEW_ARRAY: {
                    if (d == 0) {
                        ASTPath.ASTEntry e;
                        if (!r.astPath.isEmpty() && (e = r.astPath.getLast()).getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            int a = 0;
                            while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++a;
                                if (!iter.hasNext()) break;
                                tpe = iter.next();
                            }
                            r = r.replacePath(r.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", a);
                            break;
                        }
                        r = r.extend(Tree.Kind.ARRAY_TYPE, "type");
                        t = ((JCTree.JCArrayTypeTree)t).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case PARAMETERIZED_TYPE: {
                    if (d == 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) {
                        r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.arg);
                        t = (Tree)((List)((JCTree.JCTypeApply)t).getTypeArguments()).get(tpe.arg);
                        break;
                    }
                    if (d > 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        JCTree temp = ((JCTree.JCTypeApply)t).getType();
                        r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "type");
                        t = temp;
                        do {
                            temp = ((JCTree.JCFieldAccess)temp).getExpression();
                            if (!iter.hasNext()) {
                                do {
                                    r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--d > 0);
                                return r;
                            }
                            tpe = iter.next();
                            if (--d == 0) continue block8;
                        } while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case UNBOUNDED_WILDCARD: 
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    if (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.WILDCARD) {
                        t = ((JCTree.JCWildcard)t).getBound();
                        break;
                    }
                    throw new RuntimeException();
                }
                default: {
                    if (!iter.hasNext()) break;
                    throw new RuntimeException();
                }
            }
            if (!iter.hasNext()) {
                return r;
            }
            tpe = iter.next();
        }
    }

    private void mergeTypedInsertions(TypedInsertion ins1, TypedInsertion ins2) {
        this.mergeTypes(ins1.getType(), ins2.getType());
    }

    private void mergeTypes(scenelib.type.Type t1, scenelib.type.Type t2) {
        if (t1 == t2) {
            return;
        }
        switch (t1.getKind()) {
            case ARRAY: {
                ArrayType at1 = (ArrayType)t1;
                ArrayType at2 = (ArrayType)t2;
                this.mergeTypes(at1.getComponentType(), at2.getComponentType());
                return;
            }
            case BOUNDED: {
                BoundedType bt1 = (BoundedType)t1;
                BoundedType bt2 = (BoundedType)t2;
                if (bt1.getBoundKind() != bt2.getBoundKind()) {
                    throw new Error(String.format("Types have different bounds: %s %s", t1, t2));
                }
                this.mergeTypes(bt1.getBound(), bt2.getBound());
                this.mergeTypes(bt1.getName(), bt2.getName());
                return;
            }
            case DECLARED: {
                DeclaredType dt1 = (DeclaredType)t1;
                DeclaredType dt2 = (DeclaredType)t2;
                java.util.List<scenelib.type.Type> params1 = dt1.getTypeParameters();
                java.util.List<scenelib.type.Type> params2 = dt2.getTypeParameters();
                int numParams = params1.size();
                if (params2.size() != numParams) {
                    throw new Error(String.format("Types have different numbers of parameters: %s %s", t1, t2));
                }
                this.mergeTypes(dt1.getInnerType(), dt2.getInnerType());
                for (String anno : dt2.getAnnotations()) {
                    if (dt1.getAnnotations().contains(anno)) continue;
                    dt1.addAnnotation(anno);
                }
                for (int i = 0; i < numParams; ++i) {
                    this.mergeTypes(params1.get(i), params2.get(i));
                }
                return;
            }
        }
        throw new RuntimeException();
    }

    private int localDepth(Tree node) {
        Tree t = node;
        int result = 0;
        block4: while (t != null) {
            switch (t.getKind()) {
                case ANNOTATED_TYPE: {
                    t = ((AnnotatedTypeTree)t).getUnderlyingType();
                    continue block4;
                }
                case MEMBER_SELECT: {
                    if (t instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)t;
                        if (jfa.sym.kind == 1) {
                            t = jfa.getExpression();
                            continue block4;
                        }
                    }
                    t = ((MemberSelectTree)t).getExpression();
                    ++result;
                    continue block4;
                }
            }
            break;
        }
        return result;
    }

    private static int kindLevel(Insertion i) {
        switch (i.getKind()) {
            case CONSTRUCTOR: {
                return 3;
            }
            case NEW: 
            case RECEIVER: {
                return 2;
            }
            case CAST: {
                return 1;
            }
            case ANNOTATION: 
            case CLOSE_PARENTHESIS: {
                return 0;
            }
        }
        throw new Error("unrecognized case");
    }

    private static String outerClassName(String className) {
        int i = className.indexOf(36);
        if (i == -1) {
            return className;
        }
        return className.substring(0, i);
    }

    private static String innerClassName(String className) {
        int i = className.indexOf(36);
        if (i == -1) {
            return "";
        }
        return className.substring(i);
    }

    static abstract class TypeTree
    implements ExpressionTree {
        private static Map<String, TypeTag> primTags = new HashMap<String, TypeTag>();

        TypeTree() {
            primTags.put("byte", TypeTag.BYTE);
            primTags.put("char", TypeTag.CHAR);
            primTags.put("short", TypeTag.SHORT);
            primTags.put("long", TypeTag.LONG);
            primTags.put("float", TypeTag.FLOAT);
            primTags.put("int", TypeTag.INT);
            primTags.put("double", TypeTag.DOUBLE);
            primTags.put("boolean", TypeTag.BOOLEAN);
        }

        static TypeTree fromJCTree(JCTree jt) {
            if (jt != null) {
                Tree.Kind kind = jt.getKind();
                switch (kind) {
                    case ANNOTATED_TYPE: {
                        return TypeTree.fromJCTree(((JCTree.JCAnnotatedType)jt).getUnderlyingType());
                    }
                    case IDENTIFIER: {
                        return new IdentifierTT(((JCTree.JCIdent)jt).sym.getSimpleName().toString());
                    }
                    case ARRAY_TYPE: {
                        return new ArrayTT(TypeTree.fromJCTree(((JCTree.JCArrayTypeTree)jt).getType()));
                    }
                    case MEMBER_SELECT: {
                        return new MemberSelectTT(TypeTree.fromJCTree(((JCTree.JCFieldAccess)jt).getExpression()), ((JCTree.JCFieldAccess)jt).getIdentifier());
                    }
                    case EXTENDS_WILDCARD: 
                    case SUPER_WILDCARD: {
                        return new WildcardTT(kind, TypeTree.fromJCTree(((JCTree.JCWildcard)jt).getBound()));
                    }
                    case UNBOUNDED_WILDCARD: {
                        return new WildcardTT();
                    }
                    case PARAMETERIZED_TYPE: {
                        java.util.List typeArgs = ((JCTree.JCTypeApply)jt).getTypeArguments();
                        ArrayList<TypeTree> args = new ArrayList<TypeTree>(((List)typeArgs).size());
                        for (JCTree.JCExpression typeArg : typeArgs) {
                            args.add(TypeTree.fromJCTree(typeArg));
                        }
                        return new ParameterizedTypeTT(TypeTree.fromJCTree(((JCTree.JCTypeApply)jt).getType()), args);
                    }
                }
            }
            return null;
        }

        static TypeTree fromType(scenelib.type.Type type) {
            switch (type.getKind()) {
                case ARRAY: {
                    ArrayType atype = (ArrayType)type;
                    TypeTree componentType = TypeTree.fromType(atype.getComponentType());
                    return new ArrayTT(componentType);
                }
                case BOUNDED: {
                    BoundedType btype = (BoundedType)type;
                    BoundedType.BoundKind bk = btype.getBoundKind();
                    String bname = btype.getName().getName();
                    TypeTree bound = TypeTree.fromType(btype.getBound());
                    return new TypeParameterTT(bname, bk, bound);
                }
                case DECLARED: {
                    DeclaredType dtype = (DeclaredType)type;
                    if (dtype.isWildcard()) {
                        return new WildcardTT();
                    }
                    String dname = dtype.getName();
                    TypeTag typeTag = primTags.get(dname);
                    if (typeTag == null) {
                        IdentifierTT base;
                        TypeTree ret = base = new IdentifierTT(dname);
                        java.util.List<scenelib.type.Type> params = dtype.getTypeParameters();
                        DeclaredType inner = dtype.getInnerType();
                        if (!params.isEmpty()) {
                            ArrayList<TypeTree> typeArgs = new ArrayList<TypeTree>(params.size());
                            for (scenelib.type.Type t : params) {
                                typeArgs.add(TypeTree.fromType(t));
                            }
                            ret = new ParameterizedTypeTT(base, typeArgs);
                        }
                        return inner == null ? ret : TypeTree.addPrefix(TypeTree.fromType(inner), ret);
                    }
                    TypeKind typeKind = typeTag.getPrimitiveTypeKind();
                    return new PrimitiveTypeTT(typeKind);
                }
            }
            throw new RuntimeException("unknown type kind " + (Object)((Object)type.getKind()));
        }

        static TypeTree fromJavacType(Type type) {
            return TypeTree.fromType(TypeTree.javacTypeToType(type));
        }

        static scenelib.type.Type javacTypeToType(Type jtype) {
            switch (jtype.getKind()) {
                case ARRAY: {
                    Type.ArrayType arraytype = (Type.ArrayType)jtype;
                    return new ArrayType(TypeTree.javacTypeToType(arraytype.elemtype));
                }
                case DECLARED: {
                    Type.ClassType ct;
                    Type t = jtype;
                    DeclaredType d = null;
                    do {
                        DeclaredType d0 = d;
                        ct = (Type.ClassType)t;
                        d = new DeclaredType(ct.tsym.name.toString());
                        d.setInnerType(d0);
                        d0 = d;
                        for (Type a : ct.getTypeArguments()) {
                            d.addTypeParameter(TypeTree.javacTypeToType(a));
                        }
                    } while ((t = ct.getEnclosingType()).getKind() == TypeKind.DECLARED);
                    return d;
                }
                case WILDCARD: {
                    Type.WildcardType wildcard = (Type.WildcardType)jtype;
                    if (wildcard.kind == BoundKind.UNBOUND) {
                        return new DeclaredType("?");
                    }
                    return new BoundedType(new DeclaredType(jtype.tsym.name.toString()), wildcard.kind, (DeclaredType)TypeTree.javacTypeToType(wildcard.bound));
                }
                case TYPEVAR: {
                    scenelib.type.Type upperBound = TypeTree.javacTypeToType(((Type.TypeVar)jtype).getUpperBound());
                    if (upperBound.getKind() == Type.Kind.DECLARED) {
                        return new BoundedType(new DeclaredType(jtype.tsym.name.toString()), BoundedType.BoundKind.EXTENDS, (DeclaredType)upperBound);
                    }
                    return upperBound;
                }
                case INTERSECTION: {
                    return new DeclaredType(jtype.tsym.erasure_field.tsym.name.toString());
                }
                case UNION: {
                    throw new Error("UNION case not yet implemented");
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case LONG: 
                case SHORT: 
                case FLOAT: 
                case INT: {
                    return new DeclaredType(jtype.tsym.name.toString());
                }
                case ERROR: {
                    return new DeclaredType(jtype.toString());
                }
            }
            throw new Error("Found unknown type: " + jtype + " (" + (Object)((Object)jtype.getKind()) + "). Check your setup.");
        }

        private static TypeTree addPrefix(TypeTree t, TypeTree prefix) {
            switch (t.getKind()) {
                case IDENTIFIER: {
                    IdentifierTT it = (IdentifierTT)t;
                    return new MemberSelectTT(prefix, it.getName());
                }
                case MEMBER_SELECT: {
                    MemberSelectTT lt = (MemberSelectTT)t;
                    return new MemberSelectTT(TypeTree.addPrefix(lt.getExpression(), prefix), lt.getIdentifier());
                }
                case PARAMETERIZED_TYPE: {
                    ParameterizedTypeTT pt = (ParameterizedTypeTT)t;
                    return new ParameterizedTypeTT(TypeTree.addPrefix(pt.getType(), prefix), pt.getTypeArguments());
                }
            }
            throw new IllegalArgumentException("unexpected type " + t);
        }

        static final class TypeName
        implements Name {
            private final String str;

            TypeName(String str) {
                this.str = str;
            }

            @Override
            public int length() {
                return this.str.length();
            }

            @Override
            public char charAt(int index) {
                return this.str.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.str.subSequence(start, end);
            }

            @Override
            public boolean contentEquals(CharSequence cs) {
                return this.str.contentEquals(cs);
            }

            @Override
            public String toString() {
                return this.str;
            }
        }

        static final class TypeParameterTT
        extends TypeTree
        implements TypeParameterTree {
            private final String bname;
            private final BoundedType.BoundKind bk;
            private final Tree bound;

            TypeParameterTT(String bname, BoundedType.BoundKind bk, TypeTree bound) {
                this.bname = bname;
                this.bk = bk;
                this.bound = bound;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.TYPE_PARAMETER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitTypeParameter(this, data);
            }

            @Override
            public Name getName() {
                return new TypeName(this.bname);
            }

            @Override
            public java.util.List<? extends Tree> getBounds() {
                return Collections.singletonList(this.bound);
            }

            @Override
            public java.util.List<? extends AnnotationTree> getAnnotations() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.bname + " " + this.bk.toString() + " " + this.bound.toString();
            }
        }

        static final class WildcardTT
        extends TypeTree
        implements WildcardTree {
            private final TypeTree bound;
            private final Tree.Kind kind;

            WildcardTT() {
                this(Tree.Kind.UNBOUNDED_WILDCARD, null);
            }

            WildcardTT(TypeTree bound, BoundedType.BoundKind bk) {
                this(bk == BoundedType.BoundKind.SUPER ? Tree.Kind.SUPER_WILDCARD : Tree.Kind.EXTENDS_WILDCARD, bound);
            }

            WildcardTT(Tree.Kind kind, TypeTree bound) {
                this.kind = kind;
                this.bound = bound;
            }

            @Override
            public Tree.Kind getKind() {
                return this.kind;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitWildcard(this, data);
            }

            @Override
            public Tree getBound() {
                return this.bound;
            }

            public String toString() {
                return "?";
            }
        }

        static final class IdentifierTT
        extends TypeTree
        implements IdentifierTree {
            private final String name;

            IdentifierTT(String dname) {
                this.name = dname;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.IDENTIFIER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitIdentifier(this, data);
            }

            @Override
            public Name getName() {
                return new TypeName(this.name);
            }

            public String toString() {
                return this.name;
            }
        }

        static final class PrimitiveTypeTT
        extends TypeTree
        implements PrimitiveTypeTree {
            private final TypeKind typeKind;

            PrimitiveTypeTT(TypeKind typeKind) {
                this.typeKind = typeKind;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PRIMITIVE_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitPrimitiveType(this, data);
            }

            @Override
            public TypeKind getPrimitiveTypeKind() {
                return this.typeKind;
            }

            public String toString() {
                switch (this.typeKind) {
                    case BOOLEAN: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case CHAR: {
                        return "char";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case INT: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case SHORT: {
                        return "short";
                    }
                }
                throw new IllegalArgumentException("unexpected type kind " + (Object)((Object)this.typeKind));
            }
        }

        static final class ParameterizedTypeTT
        extends TypeTree
        implements ParameterizedTypeTree {
            private final TypeTree base;
            private final java.util.List<? extends Tree> typeArgs;

            ParameterizedTypeTT(TypeTree base, java.util.List<? extends Tree> typeArgs) {
                this.base = base;
                this.typeArgs = typeArgs;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PARAMETERIZED_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitParameterizedType(this, data);
            }

            @Override
            public TypeTree getType() {
                return this.base;
            }

            @Override
            public java.util.List<? extends Tree> getTypeArguments() {
                return this.typeArgs;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(this.base.toString());
                String s2 = "<";
                for (Tree tree : this.typeArgs) {
                    sb.append(s2);
                    sb.append(tree.toString());
                    s2 = ", ";
                }
                sb.append('>');
                return sb.toString();
            }
        }

        static final class MemberSelectTT
        extends TypeTree
        implements MemberSelectTree {
            private final TypeTree expr;
            private final Name name;

            MemberSelectTT(TypeTree expr, Name name) {
                this.expr = expr;
                this.name = name;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.MEMBER_SELECT;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitMemberSelect(this, data);
            }

            @Override
            public TypeTree getExpression() {
                return this.expr;
            }

            @Override
            public Name getIdentifier() {
                return this.name;
            }

            public String toString() {
                return this.expr + "." + this.name;
            }
        }

        static final class ArrayTT
        extends TypeTree
        implements ArrayTypeTree {
            private final TypeTree componentType;

            ArrayTT(TypeTree componentType) {
                this.componentType = componentType;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.ARRAY_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitArrayType(this, data);
            }

            @Override
            public TypeTree getType() {
                return this.componentType;
            }

            public String toString() {
                return this.componentType + "[]";
            }
        }
    }
}

