/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v1_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBufferPrologue;

public class PerfDataBufferPrologue
extends AbstractPerfDataBufferPrologue {
    private static final int SUPPORTED_MAJOR_VERSION = 1;
    private static final int SUPPORTED_MINOR_VERSION = 0;
    static final int PERFDATA_PROLOG_USED_OFFSET = 8;
    static final int PERFDATA_PROLOG_USED_SIZE = 4;
    static final int PERFDATA_PROLOG_OVERFLOW_OFFSET = 12;
    static final int PERFDATA_PROLOG_OVERFLOW_SIZE = 4;
    static final int PERFDATA_PROLOG_MODTIMESTAMP_OFFSET = 16;
    static final int PERFDATA_PROLOG_MODTIMESTAMP_SIZE = 8;
    static final int PERFDATA_PROLOG_SIZE = 24;
    static final String PERFDATA_BUFFER_SIZE_NAME = "sun.perfdata.size";
    static final String PERFDATA_BUFFER_USED_NAME = "sun.perfdata.used";
    static final String PERFDATA_OVERFLOW_NAME = "sun.perfdata.overflow";
    static final String PERFDATA_MODTIMESTAMP_NAME = "sun.perfdata.timestamp";

    public PerfDataBufferPrologue(ByteBuffer byteBuffer) throws MonitorException {
        super(byteBuffer);
        assert (this.getMajorVersion() == 1 && this.getMinorVersion() == 0);
    }

    @Override
    public boolean supportsAccessible() {
        return false;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    public int getUsed() {
        this.byteBuffer.position(8);
        return this.byteBuffer.getInt();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    public int getOverflow() {
        this.byteBuffer.position(12);
        return this.byteBuffer.getInt();
    }

    public long getModificationTimeStamp() {
        this.byteBuffer.position(16);
        return this.byteBuffer.getLong();
    }

    @Override
    public int getSize() {
        return 24;
    }

    public IntBuffer usedBuffer() {
        this.byteBuffer.position(8);
        IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
        intBuffer.limit(1);
        return intBuffer;
    }

    public IntBuffer sizeBuffer() {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        intBuffer.put(this.byteBuffer.capacity());
        return intBuffer;
    }

    public IntBuffer overflowBuffer() {
        this.byteBuffer.position(12);
        IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
        intBuffer.limit(1);
        return intBuffer;
    }

    public LongBuffer modificationTimeStampBuffer() {
        this.byteBuffer.position(16);
        LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
        longBuffer.limit(1);
        return longBuffer;
    }
}

