/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.UnknownVal;

public class RandomSelector<@SubstringIndexBottom T> {
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int num_elts = -1;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int observed;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random generator;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown ArrayList<T> values = new ArrayList();
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean coin_toss_mode = false;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown double keep_probability = -1.0;

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int num_elts) {
        this(num_elts, new Random());
    }

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int num_elts, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random r) {
        this.num_elts = num_elts;
        this.observed = 0;
        this.generator = r;
    }

    public RandomSelector(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown double keep_probability, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Random r) {
        this.keep_probability = keep_probability;
        this.coin_toss_mode = true;
        this.observed = 0;
        this.generator = r;
    }

    public void accept(T next) {
        int n;
        if (this.coin_toss_mode) {
            if (this.generator.nextDouble() < this.keep_probability) {
                this.values.add(next);
            }
            return;
        }
        ++this.observed;
        if (this.generator.nextDouble() < (double)this.num_elts / (double)n) {
            if (this.values.size() < this.num_elts) {
                this.values.add(next);
            } else {
                int rem = this.generator.nextInt(this.values.size());
                this.values.set(rem, next);
            }
        }
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<T> getValues() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.values);
        return ret;
    }
}

