/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.visitor;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AtmCombo;

public abstract class EquivalentAtmComboScanner<RETURN_TYPE, PARAM>
extends AbstractAtmComboVisitor<RETURN_TYPE, PARAM> {
    protected final Visited visited = new Visited();

    @Override
    public RETURN_TYPE visit(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, PARAM param) {
        this.visited.clear();
        return this.scan(type1, type2, param);
    }

    protected abstract RETURN_TYPE scanWithNull(AnnotatedTypeMirror var1, AnnotatedTypeMirror var2, PARAM var3);

    protected RETURN_TYPE scan(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, PARAM param) {
        if (type1 == null || type2 == null) {
            return this.scanWithNull(type1, type2, param);
        }
        return AtmCombo.accept(type1, type2, param, this);
    }

    protected RETURN_TYPE scan(Iterable<? extends AnnotatedTypeMirror> types1, Iterable<? extends AnnotatedTypeMirror> types2, PARAM param) {
        RETURN_TYPE r = null;
        boolean first = true;
        Iterator<? extends AnnotatedTypeMirror> tIter1 = types1.iterator();
        Iterator<? extends AnnotatedTypeMirror> tIter2 = types2.iterator();
        while (tIter1.hasNext() && tIter2.hasNext()) {
            AnnotatedTypeMirror type1 = tIter1.next();
            AnnotatedTypeMirror type2 = tIter2.next();
            r = (RETURN_TYPE)(first ? this.scan(type1, type2, param) : this.scanAndReduce(type1, type2, param, r));
        }
        return r;
    }

    protected RETURN_TYPE scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types1, Iterable<? extends AnnotatedTypeMirror> types2, PARAM param, RETURN_TYPE r) {
        return this.reduce(this.scan(types1, types2, param), r);
    }

    protected RETURN_TYPE scanAndReduce(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, PARAM param, RETURN_TYPE r) {
        return this.reduce(this.scan(type1, type2, param), r);
    }

    protected RETURN_TYPE reduce(RETURN_TYPE r1, RETURN_TYPE r2) {
        if (r1 == null) {
            return r2;
        }
        return r1;
    }

    @Override
    public RETURN_TYPE visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        return this.scan(type1.getComponentType(), type2.getComponentType(), param);
    }

    @Override
    public RETURN_TYPE visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        return this.scan(type1.getTypeArguments(), type2.getTypeArguments(), param);
    }

    @Override
    public RETURN_TYPE visitExecutable_Executable(AnnotatedTypeMirror.AnnotatedExecutableType type1, AnnotatedTypeMirror.AnnotatedExecutableType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        RETURN_TYPE r = this.scan(type1.getReturnType(), type2.getReturnType(), param);
        r = this.scanAndReduce(type1.getReceiverType(), type2.getReceiverType(), param, r);
        r = this.scanAndReduce(type1.getParameterTypes(), type2.getParameterTypes(), param, r);
        r = this.scanAndReduce(type1.getThrownTypes(), type2.getThrownTypes(), param, r);
        r = this.scanAndReduce(type1.getTypeVariables(), type2.getTypeVariables(), param, r);
        return r;
    }

    @Override
    public RETURN_TYPE visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type1, AnnotatedTypeMirror.AnnotatedIntersectionType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        return this.scan(type1.directSuperTypes(), type2.directSuperTypes(), param);
    }

    @Override
    public RETURN_TYPE visitNone_None(AnnotatedTypeMirror.AnnotatedNoType type1, AnnotatedTypeMirror.AnnotatedNoType type2, PARAM param) {
        return null;
    }

    @Override
    public RETURN_TYPE visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType type1, AnnotatedTypeMirror.AnnotatedNullType type2, PARAM param) {
        return null;
    }

    @Override
    public RETURN_TYPE visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, PARAM param) {
        return null;
    }

    @Override
    public RETURN_TYPE visitUnion_Union(AnnotatedTypeMirror.AnnotatedUnionType type1, AnnotatedTypeMirror.AnnotatedUnionType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        return this.scan(type1.getAlternatives(), type2.getAlternatives(), param);
    }

    @Override
    public RETURN_TYPE visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        RETURN_TYPE r = this.scan(type1.getUpperBound(), type2.getUpperBound(), param);
        r = this.scanAndReduce(type1.getLowerBound(), type2.getLowerBound(), param, r);
        return r;
    }

    @Override
    public RETURN_TYPE visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, PARAM param) {
        if (this.visited.contains(type1, type2)) {
            return this.visited.getResult(type1, type2);
        }
        this.visited.add(type1, type2, null);
        RETURN_TYPE r = this.scan(type1.getExtendsBound(), type2.getExtendsBound(), param);
        r = this.scanAndReduce(type1.getSuperBound(), type2.getSuperBound(), param, r);
        return r;
    }

    protected class Visited {
        private final Map<AnnotatedTypeMirror, Map<AnnotatedTypeMirror, RETURN_TYPE>> visits = new IdentityHashMap();

        protected Visited() {
        }

        public void clear() {
            this.visits.clear();
        }

        public boolean contains(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
            Map recordFor1 = this.visits.get(type1);
            return recordFor1 != null && recordFor1.containsKey(type2);
        }

        public RETURN_TYPE getResult(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
            Map recordFor1 = this.visits.get(type1);
            if (recordFor1 == null) {
                return null;
            }
            return recordFor1.get(type2);
        }

        public void add(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, RETURN_TYPE ret) {
            Map recordFor1 = this.visits.get(type1);
            if (recordFor1 == null) {
                recordFor1 = new IdentityHashMap();
                this.visits.put(type1, recordFor1);
            }
            recordFor1.put(type2, ret);
        }
    }
}

