/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.signedness.qual.Constant;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationBuilder;

public class SignednessAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror UNKNOWN_SIGNEDNESS;
    private final AnnotationMirror UNSIGNED;
    private final AnnotationMirror SIGNED;
    private final AnnotationMirror CONSTANT;
    private ValueAnnotatedTypeFactory valueAtypefactory;

    private ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        if (this.valueAtypefactory == null) {
            this.valueAtypefactory = (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
        }
        return this.valueAtypefactory;
    }

    public SignednessAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN_SIGNEDNESS = AnnotationBuilder.fromClass(this.elements, UnknownSignedness.class);
        this.UNSIGNED = AnnotationBuilder.fromClass(this.elements, Unsigned.class);
        this.SIGNED = AnnotationBuilder.fromClass(this.elements, Signed.class);
        this.CONSTANT = AnnotationBuilder.fromClass(this.elements, Constant.class);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithoutPolyAll(new Class[0]);
    }

    @Override
    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        this.addUnknownSignednessToSomeLocals(tree, type);
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
    }

    private void addUnknownSignednessToSomeLocals(Tree tree, AnnotatedTypeMirror type) {
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: {
                QualifierDefaults defaults = new QualifierDefaults(this.elements, this);
                defaults.addCheckedCodeDefault(this.UNKNOWN_SIGNEDNESS, TypeUseLocation.LOCAL_VARIABLE);
                defaults.annotate(tree, type);
                break;
            }
        }
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new SignednessTreeAnnotator(this), super.createTreeAnnotator());
    }

    private class SignednessTreeAnnotator
    extends TreeAnnotator {
        public SignednessTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        private void annotateBoolean(AnnotatedTypeMirror type) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    type.addAnnotation(SignednessAnnotatedTypeFactory.this.UNKNOWN_SIGNEDNESS);
                    break;
                }
            }
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            switch (tree.getKind()) {
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    AnnotatedTypeMirror lht = SignednessAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                    type.replaceAnnotations(lht.getAnnotations());
                    break;
                }
            }
            this.annotateBoolean(type);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, AnnotatedTypeMirror type) {
            this.annotateBoolean(type);
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, AnnotatedTypeMirror type) {
            ValueAnnotatedTypeFactory valFact;
            Range treeRange;
            TypeMirror javaType = type.getUnderlyingType();
            TypeKind javaTypeKind = javaType.getKind();
            if ((javaTypeKind == TypeKind.BYTE || javaTypeKind == TypeKind.CHAR || javaTypeKind == TypeKind.SHORT || javaTypeKind == TypeKind.INT || javaTypeKind == TypeKind.LONG) && (treeRange = IndexUtil.getPossibleValues((valFact = SignednessAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory()).getAnnotatedType(tree), valFact)) != null) {
                switch (javaType.getKind()) {
                    case BYTE: 
                    case CHAR: {
                        if (!treeRange.isWithin(0L, 127L)) break;
                        type.replaceAnnotation(SignednessAnnotatedTypeFactory.this.CONSTANT);
                        break;
                    }
                    case SHORT: {
                        if (!treeRange.isWithin(0L, 32767L)) break;
                        type.replaceAnnotation(SignednessAnnotatedTypeFactory.this.CONSTANT);
                        break;
                    }
                    case INT: {
                        if (!treeRange.isWithin(0L, Integer.MAX_VALUE)) break;
                        type.replaceAnnotation(SignednessAnnotatedTypeFactory.this.CONSTANT);
                        break;
                    }
                    case LONG: {
                        if (!treeRange.isWithin(0L, Long.MAX_VALUE)) break;
                        type.replaceAnnotation(SignednessAnnotatedTypeFactory.this.CONSTANT);
                        break;
                    }
                }
            }
            return null;
        }
    }
}

