/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.OffsetDependentTypesHelper;
import org.checkerframework.checker.index.inequality.LessThanAnnotatedTypeFactory;
import org.checkerframework.checker.index.inequality.LessThanChecker;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.lowerbound.LowerBoundChecker;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.checker.index.qual.NegativeIndexFor;
import org.checkerframework.checker.index.qual.PolyIndex;
import org.checkerframework.checker.index.qual.PolyUpperBound;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SearchIndexFor;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.samelen.SameLenChecker;
import org.checkerframework.checker.index.searchindex.SearchIndexAnnotatedTypeFactory;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.checker.index.substringindex.SubstringIndexAnnotatedTypeFactory;
import org.checkerframework.checker.index.substringindex.SubstringIndexChecker;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class UpperBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror BOTTOM;
    public final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public UpperBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, UpperBoundUnknown.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, UpperBoundBottom.class);
        this.POLY = AnnotationBuilder.fromClass(this.elements, PolyUpperBound.class);
        this.addAliasedAnnotation(IndexFor.class, this.createLTLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(IndexOrLow.class, this.createLTLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(IndexOrHigh.class, this.createLTEqLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(SearchIndexFor.class, this.createLTLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(NegativeIndexFor.class, this.createLTLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(LengthOf.class, this.createLTEqLengthOfAnnotation(new String[0]), true, new String[0]);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyIndex.class, this.POLY);
        this.imf = new IndexMethodIdentifier(this);
        this.postInit();
    }

    IndexMethodIdentifier getMethodIdentifier() {
        return this.imf;
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(UpperBoundUnknown.class, LTEqLengthOf.class, LTLengthOf.class, LTOMLengthOf.class, UpperBoundBottom.class, PolyUpperBound.class));
    }

    ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    private SearchIndexAnnotatedTypeFactory getSearchIndexAnnotatedTypeFactory() {
        return (SearchIndexAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SearchIndexChecker.class);
    }

    SubstringIndexAnnotatedTypeFactory getSubstringIndexAnnotatedTypeFactory() {
        return (SubstringIndexAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SubstringIndexChecker.class);
    }

    SameLenAnnotatedTypeFactory getSameLenAnnotatedTypeFactory() {
        return (SameLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SameLenChecker.class);
    }

    LowerBoundAnnotatedTypeFactory getLowerBoundAnnotatedTypeFactory() {
        return (LowerBoundAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(LowerBoundChecker.class);
    }

    public LessThanAnnotatedTypeFactory getLessThanAnnotatedTypeFactory() {
        return (LessThanAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(LessThanChecker.class);
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addUpperBoundTypeFromValueType(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (iUseFlow && tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
            this.addUpperBoundTypeFromValueType(valueType, type);
        }
    }

    private void addUpperBoundTypeFromValueType(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (AnnotationUtils.containsSameByClass(valueType.getAnnotations(), BottomVal.class)) {
            type.replaceAnnotation(this.BOTTOM);
        }
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new OffsetDependentTypesHelper(this);
    }

    public AnnotationMirror sameLenAnnotationFromTree(Tree tree) {
        AnnotatedTypeMirror sameLenType = this.getSameLenAnnotatedTypeFactory().getAnnotatedType(tree);
        return sameLenType.getAnnotation(SameLen.class);
    }

    public boolean isMathMin(Tree methodTree) {
        return this.imf.isMathMin(methodTree);
    }

    public boolean isRandomNextInt(Tree methodTree) {
        return this.imf.isRandomNextInt(methodTree, this.processingEnv);
    }

    AnnotationMirror createLTLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    AnnotationMirror createLTEqLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTEqLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    public boolean hasLowerBoundTypeByClass(Node node, Class<? extends Annotation> classOfType) {
        return AnnotationUtils.areSameByClass(this.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(node.getTree()).getAnnotationInHierarchy(this.getLowerBoundAnnotatedTypeFactory().UNKNOWN), classOfType);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UpperBoundQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new UpperBoundTreeAnnotator(this), super.createTreeAnnotator());
    }

    public AnnotationMirror convertUBQualifierToAnnotation(UBQualifier qualifier) {
        if (qualifier.isUnknown()) {
            return this.UNKNOWN;
        }
        if (qualifier.isBottom()) {
            return this.BOTTOM;
        }
        if (qualifier.isPoly()) {
            return this.POLY;
        }
        UBQualifier.LessThanLengthOf ltlQualifier = (UBQualifier.LessThanLengthOf)qualifier;
        return ltlQualifier.convertToAnnotation(this.processingEnv);
    }

    UBQualifier fromLessThan(ExpressionTree tree, TreePath treePath) {
        List<String> lessThanExpressions = this.getLessThanAnnotatedTypeFactory().getLessThanExpressions(tree);
        if (lessThanExpressions == null) {
            return null;
        }
        UBQualifier ubQualifier = this.fromLessThanOrEqual(tree, treePath, lessThanExpressions);
        if (ubQualifier != null) {
            return ubQualifier.plusOffset(1);
        }
        return null;
    }

    UBQualifier fromLessThanOrEqual(ExpressionTree tree, TreePath treePath) {
        List<String> lessThanExpressions = this.getLessThanAnnotatedTypeFactory().getLessThanExpressions(tree);
        if (lessThanExpressions == null) {
            return null;
        }
        UBQualifier ubQualifier = this.fromLessThanOrEqual(tree, treePath, lessThanExpressions);
        return ubQualifier;
    }

    private UBQualifier fromLessThanOrEqual(Tree tree, TreePath treePath, List<String> lessThanExpressions) {
        UBQualifier ubQualifier = null;
        for (String expression : lessThanExpressions) {
            CFValue value;
            CFStore store;
            FlowExpressions.Receiver receiver;
            try {
                receiver = this.getReceiverFromJavaExpressionString(expression, treePath);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                receiver = null;
            }
            if (receiver == null || !CFAbstractStore.canInsertReceiver(receiver) || (store = (CFStore)this.getStoreBefore(tree)) == null || (value = (CFValue)store.getValue(receiver)) == null || value.getAnnotations().size() != 1) continue;
            UBQualifier newUBQ = UBQualifier.createUBQualifier(value.getAnnotations().iterator().next());
            if (ubQualifier == null) {
                ubQualifier = newUBQ;
                continue;
            }
            ubQualifier = ubQualifier.glb(newUBQ);
        }
        return ubQualifier;
    }

    protected class UpperBoundTreeAnnotator
    extends TreeAnnotator {
        public UpperBoundTreeAnnotator(UpperBoundAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (UpperBoundAnnotatedTypeFactory.this.isMathMin(tree)) {
                AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN), rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN)));
            }
            if (UpperBoundAnnotatedTypeFactory.this.isRandomNextInt(tree)) {
                AnnotatedTypeMirror argType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotationMirror anno = argType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                UBQualifier qualifier = UBQualifier.createUBQualifier(anno);
                qualifier = qualifier.plusOffset(1);
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qualifier));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            if (node.getKind() == Tree.Kind.BITWISE_COMPLEMENT) {
                this.addAnnotationForBitwiseComplement(UpperBoundAnnotatedTypeFactory.this.getSearchIndexAnnotatedTypeFactory().getAnnotatedType(node.getExpression()), type);
            } else {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            return (Void)super.visitUnary(node, type);
        }

        private void addAnnotationForBitwiseComplement(AnnotatedTypeMirror searchIndexType, AnnotatedTypeMirror typeDst) {
            if (AnnotationUtils.containsSameByClass(searchIndexType.getAnnotations(), NegativeIndexFor.class)) {
                AnnotationMirror nif = searchIndexType.getAnnotation(NegativeIndexFor.class);
                List<String> arrays = IndexUtil.getValueOfAnnotationWithStringArgument(nif);
                List<String> negativeOnes = Collections.nCopies(arrays.size(), "-1");
                UBQualifier qual = UBQualifier.createUBQualifier(arrays, negativeOnes);
                typeDst.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qual));
            } else {
                typeDst.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            return (Void)super.visitCompoundAssignment(node, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: 
                case MINUS: {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
                case REMAINDER: {
                    this.addAnnotationForRemainder(left, right, type);
                    break;
                }
                case AND: {
                    this.addAnnotationForAnd(left, right, type);
                    break;
                }
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    this.addAnnotationForRightShift(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForRightShift(ExpressionTree left, ExpressionTree right, AnnotatedTypeMirror type) {
            LowerBoundAnnotatedTypeFactory lowerBoundATF = UpperBoundAnnotatedTypeFactory.this.getLowerBoundAnnotatedTypeFactory();
            if (lowerBoundATF.isNonNegative(left)) {
                int divisor;
                UBQualifier plusDivQualifier;
                AnnotationMirror annotation2 = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(left).getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                Long shiftAmount = IndexUtil.getExactValue(right, UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
                if (shiftAmount != null && shiftAmount >= 0L && shiftAmount < 31L && !(plusDivQualifier = this.plusTreeDivideByVal(divisor = 1 << (int)shiftAmount.longValue(), left)).isUnknown()) {
                    UBQualifier qualifier = UBQualifier.createUBQualifier(annotation2);
                    qualifier = qualifier.glb(plusDivQualifier);
                    annotation2 = UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qualifier);
                }
                type.addAnnotation(annotation2);
            }
        }

        private void addAnnotationForAnd(ExpressionTree left, ExpressionTree right, AnnotatedTypeMirror type) {
            LowerBoundAnnotatedTypeFactory lowerBoundATF = UpperBoundAnnotatedTypeFactory.this.getLowerBoundAnnotatedTypeFactory();
            AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(left);
            AnnotationMirror leftResultType = UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
            if (lowerBoundATF.isNonNegative(left)) {
                leftResultType = leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(right);
            AnnotationMirror rightResultType = UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
            if (lowerBoundATF.isNonNegative(right)) {
                rightResultType = rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftResultType, rightResultType));
        }

        private ExpressionTree getLengthSequenceTree(ExpressionTree lengthTree) {
            return IndexUtil.getLengthSequenceTree(lengthTree, UpperBoundAnnotatedTypeFactory.this.imf, UpperBoundAnnotatedTypeFactory.this.processingEnv);
        }

        private void addAnnotationForRemainder(ExpressionTree numeratorTree, ExpressionTree divisorTree, AnnotatedTypeMirror resultType) {
            LowerBoundAnnotatedTypeFactory lowerBoundATF = UpperBoundAnnotatedTypeFactory.this.getLowerBoundAnnotatedTypeFactory();
            UBQualifier result = UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            if (lowerBoundATF.isNonNegative(numeratorTree)) {
                result = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(numeratorTree), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
            if (lowerBoundATF.isNonNegative(divisorTree)) {
                UBQualifier divisor = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(divisorTree), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                result = result.glb(divisor.plusOffset(1));
            }
            resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(result));
        }

        private void addAnnotationForDivide(ExpressionTree numeratorTree, ExpressionTree divisorTree, AnnotatedTypeMirror resultType) {
            Long divisor = IndexUtil.getExactValue(divisorTree, UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory());
            if (divisor == null) {
                resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return;
            }
            UBQualifier result = UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            UBQualifier numerator = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(numeratorTree), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (numerator.isLessThanLengthQualifier()) {
                result = ((UBQualifier.LessThanLengthOf)numerator).divide(divisor.intValue());
            }
            result = result.glb(this.plusTreeDivideByVal(divisor.intValue(), numeratorTree));
            ExpressionTree numeratorSequenceTree = this.getLengthSequenceTree(numeratorTree);
            if (numeratorSequenceTree != null && divisor > 1L) {
                String arrayName = numeratorSequenceTree.toString();
                int minlen = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getMinLenFromString(arrayName, numeratorTree, UpperBoundAnnotatedTypeFactory.this.getPath(numeratorTree));
                if (minlen > 0) {
                    result = result.glb(UBQualifier.createUBQualifier(arrayName, "0"));
                }
            }
            resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(result));
        }

        private UBQualifier plusTreeDivideByVal(int divisor, ExpressionTree numeratorTree) {
            numeratorTree = TreeUtils.skipParens(numeratorTree);
            if (divisor < 2 || numeratorTree.getKind() != Tree.Kind.PLUS) {
                return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            }
            BinaryTree plusTree = (BinaryTree)numeratorTree;
            UBQualifier left = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getLeftOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            UBQualifier right = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getRightOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (left.isLessThanLengthQualifier() && right.isLessThanLengthQualifier()) {
                UBQualifier.LessThanLengthOf leftLTL = (UBQualifier.LessThanLengthOf)left;
                UBQualifier.LessThanLengthOf rightLTL = (UBQualifier.LessThanLengthOf)right;
                ArrayList<String> sequences = new ArrayList<String>();
                for (String string : leftLTL.getSequences()) {
                    if (!rightLTL.isLessThanLengthOf(string) || !leftLTL.isLessThanLengthOf(string)) continue;
                    sequences.add(string);
                }
                if (!sequences.isEmpty()) {
                    return UBQualifier.createUBQualifier(sequences, Collections.emptyList());
                }
            }
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree seqLenTree, AnnotatedTypeMirror type) {
            ExpressionTree seqTree = this.getLengthSequenceTree(seqLenTree);
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && seqTree != null) {
                MethodInvocationTree mitree = (MethodInvocationTree)randTree;
                if (UpperBoundAnnotatedTypeFactory.this.imf.isMathRandom(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(seqTree.toString()));
                    return true;
                }
                if (UpperBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(seqTree.toString()));
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }

    protected final class UpperBoundQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public UpperBoundQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier glb = a1Obj.glb(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(glb);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier lub = a1Obj.lub(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public AnnotationMirror widenedUpperBound(AnnotationMirror newQualifier, AnnotationMirror previousQualifier) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(newQualifier);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(previousQualifier);
            UBQualifier lub = a1Obj.widenUpperBound(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public int numberOfIterationsBeforeWidening() {
            return 10;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            UBQualifier subtype = UBQualifier.createUBQualifier(subAnno);
            UBQualifier supertype = UBQualifier.createUBQualifier(superAnno);
            return subtype.isSubtype(supertype);
        }
    }
}

