/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.parse.xml;

import com.sun.xml.internal.rngom.ast.builder.BuildException;
import com.sun.xml.internal.rngom.ast.builder.IncludedGrammar;
import com.sun.xml.internal.rngom.ast.builder.SchemaBuilder;
import com.sun.xml.internal.rngom.ast.builder.Scope;
import com.sun.xml.internal.rngom.ast.om.ParsedPattern;
import com.sun.xml.internal.rngom.parse.IllegalSchemaException;
import com.sun.xml.internal.rngom.parse.Parseable;
import com.sun.xml.internal.rngom.parse.xml.SchemaParser;
import com.sun.xml.internal.rngom.xml.sax.JAXPXMLReaderCreator;
import com.sun.xml.internal.rngom.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParseable
implements Parseable {
    private final InputSource in;
    final XMLReaderCreator xrc;
    final ErrorHandler eh;

    public SAXParseable(InputSource in, ErrorHandler eh, XMLReaderCreator xrc) {
        this.xrc = xrc;
        this.eh = eh;
        this.in = in;
    }

    public SAXParseable(InputSource in, ErrorHandler eh) {
        this(in, eh, new JAXPXMLReaderCreator());
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xr = this.xrc.createXMLReader();
            SchemaParser sp = new SchemaParser(this, xr, this.eh, schemaBuilder, null, null, "");
            xr.parse(this.in);
            ParsedPattern p = sp.getParsedPattern();
            return schemaBuilder.expandPattern(p);
        }
        catch (SAXException e) {
            throw SAXParseable.toBuildException(e);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public ParsedPattern parseInclude(String uri, SchemaBuilder schemaBuilder, IncludedGrammar g2, String inheritedNs) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xr = this.xrc.createXMLReader();
            SchemaParser sp = new SchemaParser(this, xr, this.eh, schemaBuilder, g2, g2, inheritedNs);
            xr.parse(SAXParseable.makeInputSource(xr, uri));
            return sp.getParsedPattern();
        }
        catch (SAXException e) {
            throw SAXParseable.toBuildException(e);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public ParsedPattern parseExternal(String uri, SchemaBuilder schemaBuilder, Scope s2, String inheritedNs) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xr = this.xrc.createXMLReader();
            SchemaParser sp = new SchemaParser(this, xr, this.eh, schemaBuilder, null, s2, inheritedNs);
            xr.parse(SAXParseable.makeInputSource(xr, uri));
            return sp.getParsedPattern();
        }
        catch (SAXException e) {
            throw SAXParseable.toBuildException(e);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    private static InputSource makeInputSource(XMLReader xr, String systemId) throws IOException, SAXException {
        InputSource inputSource;
        EntityResolver er = xr.getEntityResolver();
        if (er != null && (inputSource = er.resolveEntity(null, systemId)) != null) {
            return inputSource;
        }
        return new InputSource(systemId);
    }

    static BuildException toBuildException(SAXException e) {
        Exception inner = e.getException();
        if (inner instanceof BuildException) {
            throw (BuildException)inner;
        }
        throw new BuildException(e);
    }
}

