/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.connect.TransportTimeoutException;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.SocketConnection;
import com.sun.tools.jdi.SocketTransportServiceCapabilities;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class SocketTransportService
extends TransportService {
    private ResourceBundle messages = null;

    void handshake(Socket socket, long l) throws IOException {
        int n;
        socket.setSoTimeout((int)l);
        byte[] byArray = "JDWP-Handshake".getBytes("UTF-8");
        socket.getOutputStream().write(byArray);
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; i += n) {
            try {
                n = socket.getInputStream().read(byArray2, i, byArray.length - i);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new IOException("handshake timeout");
            }
            if (n >= 0) continue;
            socket.close();
            throw new IOException("handshake failed - connection prematurally closed");
        }
        for (n = 0; n < byArray.length; ++n) {
            if (byArray2[n] == byArray[n]) continue;
            throw new IOException("handshake failed - unrecognized message from target VM");
        }
        socket.setSoTimeout(0);
    }

    @Override
    public String name() {
        return "Socket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String description() {
        SocketTransportService socketTransportService = this;
        synchronized (socketTransportService) {
            if (this.messages == null) {
                this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
            }
        }
        return this.messages.getString("socket_transportservice.description");
    }

    @Override
    public TransportService.Capabilities capabilities() {
        return new SocketTransportServiceCapabilities();
    }

    @Override
    public Connection attach(String string, long l, long l2) throws IOException {
        int n;
        String string2;
        String string3;
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            string3 = InetAddress.getLocalHost().getHostName();
            string2 = string;
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string3, n);
        Socket socket = new Socket();
        try {
            socket.connect(inetSocketAddress, (int)l);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TransportTimeoutException("timed out trying to establish connection");
        }
        try {
            this.handshake(socket, l2);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return new SocketConnection(socket);
    }

    TransportService.ListenKey startListening(String string, int n) throws IOException {
        InetSocketAddress inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(inetSocketAddress);
        return new SocketListenKey(serverSocket);
    }

    @Override
    public TransportService.ListenKey startListening(String string) throws IOException {
        int n;
        if (string == null || string.length() == 0) {
            string = "0";
        }
        int n2 = string.indexOf(58);
        String string2 = null;
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
        }
        try {
            n = Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        return this.startListening(string2, n);
    }

    @Override
    public TransportService.ListenKey startListening() throws IOException {
        return this.startListening(null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening(TransportService.ListenKey listenKey) throws IOException {
        if (!(listenKey instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        TransportService.ListenKey listenKey2 = listenKey;
        synchronized (listenKey2) {
            ServerSocket serverSocket = ((SocketListenKey)listenKey).socket();
            if (serverSocket.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
            serverSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection accept(TransportService.ListenKey listenKey, long l, long l2) throws IOException {
        ServerSocket serverSocket;
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (!(listenKey instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        Object object = listenKey;
        synchronized (object) {
            serverSocket = ((SocketListenKey)listenKey).socket();
            if (serverSocket.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
        }
        serverSocket.setSoTimeout((int)l);
        try {
            object = serverSocket.accept();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new TransportTimeoutException("timeout waiting for connection");
        }
        this.handshake((Socket)object, l2);
        return new SocketConnection((Socket)object);
    }

    public String toString() {
        return this.name();
    }

    static class SocketListenKey
    extends TransportService.ListenKey {
        ServerSocket ss;

        SocketListenKey(ServerSocket serverSocket) {
            this.ss = serverSocket;
        }

        ServerSocket socket() {
            return this.ss;
        }

        @Override
        public String address() {
            String string;
            Object object;
            InetAddress inetAddress = this.ss.getInetAddress();
            if (inetAddress.isAnyLocalAddress()) {
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    object = new byte[]{127, 0, 0, 1};
                    try {
                        inetAddress = InetAddress.getByAddress("127.0.0.1", (byte[])object);
                    }
                    catch (UnknownHostException unknownHostException2) {
                        throw new InternalError("unable to get local hostname");
                    }
                }
            }
            Object object2 = ((String)(object = inetAddress.getHostName())).equals(string = inetAddress.getHostAddress()) ? (inetAddress instanceof Inet6Address ? "[" + string + "]" : string) : object;
            return (String)object2 + ":" + this.ss.getLocalPort();
        }

        public String toString() {
            return this.address();
        }
    }
}

