/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.DoubleValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class DoubleValueImpl
extends PrimitiveValueImpl
implements DoubleValue {
    private double value;

    DoubleValueImpl(VirtualMachine virtualMachine, double d) {
        super(virtualMachine);
        this.value = d;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleValue) {
            return this.value == ((DoubleValue)object).value() && super.equals(object);
        }
        return false;
    }

    @Override
    public int compareTo(DoubleValue doubleValue) {
        double d = doubleValue.value();
        if (this.value() < d) {
            return -1;
        }
        if (this.value() == d) {
            return 0;
        }
        return 1;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public Type type() {
        return this.vm.theDoubleType();
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127.0 || this.value < -128.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535.0 || this.value < 0.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767.0 || this.value < -32768.0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    int checkedIntValue() throws InvalidTypeException {
        if (this.value > 2.147483647E9 || this.value < -2.147483648E9) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    @Override
    long checkedLongValue() throws InvalidTypeException {
        long l = (long)this.value;
        if ((double)l != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to long");
        }
        return super.checkedLongValue();
    }

    @Override
    float checkedFloatValue() throws InvalidTypeException {
        float f = (float)this.value;
        if ((double)f != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to float");
        }
        return super.checkedFloatValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 68;
    }
}

