/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TryBlockWriter
extends InstructionDetailWriter {
    private Map<Integer, List<Code_attribute.Exception_data>> pcMap;
    private Map<Code_attribute.Exception_data, Integer> indexMap;
    private ConstantWriter constantWriter;

    static TryBlockWriter instance(Context context) {
        TryBlockWriter tryBlockWriter = context.get(TryBlockWriter.class);
        if (tryBlockWriter == null) {
            tryBlockWriter = new TryBlockWriter(context);
        }
        return tryBlockWriter;
    }

    protected TryBlockWriter(Context context) {
        super(context);
        context.put(TryBlockWriter.class, this);
        this.constantWriter = ConstantWriter.instance(context);
    }

    public void reset(Code_attribute code_attribute) {
        this.indexMap = new HashMap<Code_attribute.Exception_data, Integer>();
        this.pcMap = new HashMap<Integer, List<Code_attribute.Exception_data>>();
        for (int i = 0; i < code_attribute.exception_table.length; ++i) {
            Code_attribute.Exception_data exception_data = code_attribute.exception_table[i];
            this.indexMap.put(exception_data, i);
            this.put(exception_data.start_pc, exception_data);
            this.put(exception_data.end_pc, exception_data);
            this.put(exception_data.handler_pc, exception_data);
        }
    }

    @Override
    public void writeDetails(Instruction instruction) {
        this.writeTrys(instruction, NoteKind.END);
        this.writeTrys(instruction, NoteKind.START);
        this.writeTrys(instruction, NoteKind.HANDLER);
    }

    public void writeTrys(Instruction instruction, NoteKind noteKind) {
        String string = this.space(2);
        int n = instruction.getPC();
        List<Code_attribute.Exception_data> list = this.pcMap.get(n);
        if (list != null) {
            ListIterator<Code_attribute.Exception_data> listIterator = list.listIterator(noteKind == NoteKind.END ? list.size() : 0);
            while (noteKind == NoteKind.END ? listIterator.hasPrevious() : listIterator.hasNext()) {
                Code_attribute.Exception_data exception_data = noteKind == NoteKind.END ? listIterator.previous() : listIterator.next();
                if (!noteKind.match(exception_data, n)) continue;
                this.print(string);
                this.print(noteKind.text);
                this.print("[");
                this.print(this.indexMap.get(exception_data));
                this.print("] ");
                if (exception_data.catch_type == 0) {
                    this.print("finally");
                } else {
                    this.print("#" + exception_data.catch_type);
                    this.print(" // ");
                    this.constantWriter.write(exception_data.catch_type);
                }
                this.println();
            }
        }
    }

    private void put(int n, Code_attribute.Exception_data exception_data) {
        List<Code_attribute.Exception_data> list = this.pcMap.get(n);
        if (list == null) {
            list = new ArrayList<Code_attribute.Exception_data>();
            this.pcMap.put(n, list);
        }
        if (!list.contains(exception_data)) {
            list.add(exception_data);
        }
    }

    public static enum NoteKind {
        START("try"){

            @Override
            public boolean match(Code_attribute.Exception_data exception_data, int n) {
                return n == exception_data.start_pc;
            }
        }
        ,
        END("end try"){

            @Override
            public boolean match(Code_attribute.Exception_data exception_data, int n) {
                return n == exception_data.end_pc;
            }
        }
        ,
        HANDLER("catch"){

            @Override
            public boolean match(Code_attribute.Exception_data exception_data, int n) {
                return n == exception_data.handler_pc;
            }
        };

        public final String text;

        private NoteKind(String string2) {
            this.text = string2;
        }

        public abstract boolean match(Code_attribute.Exception_data var1, int var2);
    }
}

