/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.generator.bean;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JEnumConstant;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JExpressionImpl;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JForEach;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JJavaName;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.codemodel.internal.fmt.JStaticJavaFile;
import com.sun.istack.internal.NotNull;
import com.sun.tools.internal.xjc.AbortException;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.api.SpecVersion;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlAnyAttributeWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlEnumValueWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlEnumWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlJavaTypeAdapterWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlMimeTypeWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlRootElementWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlSeeAlsoWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlTypeWriter;
import com.sun.tools.internal.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.ElementOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.ImplStructureStrategy;
import com.sun.tools.internal.xjc.generator.bean.Messages;
import com.sun.tools.internal.xjc.generator.bean.MethodWriter;
import com.sun.tools.internal.xjc.generator.bean.PackageOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.field.FieldRenderer;
import com.sun.tools.internal.xjc.model.CAdapter;
import com.sun.tools.internal.xjc.model.CAttributePropertyInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CClassInfoParent;
import com.sun.tools.internal.xjc.model.CClassRef;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CEnumConstant;
import com.sun.tools.internal.xjc.model.CEnumLeafInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.nav.NClass;
import com.sun.tools.internal.xjc.model.nav.NType;
import com.sun.tools.internal.xjc.outline.Aspect;
import com.sun.tools.internal.xjc.outline.EnumConstantOutline;
import com.sun.tools.internal.xjc.outline.EnumOutline;
import com.sun.tools.internal.xjc.outline.FieldOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.tools.internal.xjc.outline.PackageOutline;
import com.sun.tools.internal.xjc.util.CodeModelClassFactory;
import com.sun.xml.internal.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.internal.xsom.XmlString;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.namespace.QName;

public final class BeanGenerator
implements Outline {
    private final CodeModelClassFactory codeModelClassFactory;
    private final ErrorReceiver errorReceiver;
    private final Map<JPackage, PackageOutlineImpl> packageContexts = new LinkedHashMap<JPackage, PackageOutlineImpl>();
    private final Map<CClassInfo, ClassOutlineImpl> classes = new LinkedHashMap<CClassInfo, ClassOutlineImpl>();
    private final Map<CEnumLeafInfo, EnumOutline> enums = new LinkedHashMap<CEnumLeafInfo, EnumOutline>();
    private final Map<Class, JClass> generatedRuntime = new LinkedHashMap<Class, JClass>();
    private final Model model;
    private final JCodeModel codeModel;
    private final Map<CPropertyInfo, FieldOutline> fields = new LinkedHashMap<CPropertyInfo, FieldOutline>();
    final Map<CElementInfo, ElementOutlineImpl> elements = new LinkedHashMap<CElementInfo, ElementOutlineImpl>();
    private final CClassInfoParent.Visitor<JClassContainer> exposedContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo bean) {
            return BeanGenerator.this.getClazz((CClassInfo)bean).ref;
        }

        @Override
        public JClassContainer onElement(CElementInfo element) {
            return BeanGenerator.this.getElement((CElementInfo)element).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage pkg) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(pkg, Aspect.EXPOSED);
        }
    };
    private final CClassInfoParent.Visitor<JClassContainer> implContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo bean) {
            return BeanGenerator.this.getClazz((CClassInfo)bean).implClass;
        }

        @Override
        public JClassContainer onElement(CElementInfo element) {
            return BeanGenerator.this.getElement((CElementInfo)element).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage pkg) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(pkg, Aspect.IMPLEMENTATION);
        }
    };

    public static Outline generate(Model model, ErrorReceiver _errorReceiver) {
        try {
            return new BeanGenerator(model, _errorReceiver);
        }
        catch (AbortException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BeanGenerator(Model _model, ErrorReceiver _errorReceiver) {
        void var6_10;
        JPackage[] packages;
        this.model = _model;
        this.codeModel = this.model.codeModel;
        this.errorReceiver = _errorReceiver;
        this.codeModelClassFactory = new CodeModelClassFactory(this.errorReceiver);
        for (CEnumLeafInfo p : this.model.enums().values()) {
            this.enums.put(p, this.generateEnumDef(p));
        }
        JPackage[] arr$ = packages = this.getUsedPackages(Aspect.EXPOSED);
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_10 < len$) {
            JPackage pkg = arr$[var6_10];
            this.getPackageContext(pkg);
            ++var6_10;
        }
        for (CClassInfo bean : this.model.beans().values()) {
            this.getClazz(bean);
        }
        for (PackageOutlineImpl p : this.packageContexts.values()) {
            p.calcDefaultValues();
        }
        JClass OBJECT = this.codeModel.ref(Object.class);
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            CClassInfoParent base;
            CClassInfo superClass = classOutlineImpl.target.getBaseClass();
            if (superClass != null) {
                this.model.strategy._extends(classOutlineImpl, this.getClazz(superClass));
            } else {
                CClassRef refSuperClass = classOutlineImpl.target.getRefBaseClass();
                if (refSuperClass != null) {
                    classOutlineImpl.implClass._extends(refSuperClass.toType(this, Aspect.EXPOSED));
                } else {
                    if (this.model.rootClass != null && classOutlineImpl.implClass._extends().equals(OBJECT)) {
                        classOutlineImpl.implClass._extends(this.model.rootClass);
                    }
                    if (this.model.rootInterface != null) {
                        classOutlineImpl.ref._implements(this.model.rootInterface);
                    }
                }
            }
            if (this.model.serializable) {
                classOutlineImpl.implClass._implements(Serializable.class);
                if (this.model.serialVersionUID != null) {
                    classOutlineImpl.implClass.field(28, this.codeModel.LONG, "serialVersionUID", JExpr.lit(this.model.serialVersionUID));
                }
            }
            if ((base = classOutlineImpl.target.parent()) == null || !(base instanceof CClassInfo)) continue;
            String pkg = base.getOwnerPackage().name();
            String shortName = base.fullName().substring(base.fullName().indexOf(pkg) + pkg.length() + 1);
            if (!classOutlineImpl.target.shortName.equals(shortName)) continue;
            this.getErrorReceiver().error(classOutlineImpl.target.getLocator(), Messages.ERR_KEYNAME_COLLISION.format(shortName));
        }
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            this.generateClassBody(classOutlineImpl);
        }
        for (EnumOutline enumOutline : this.enums.values()) {
            this.generateEnumBody(enumOutline);
        }
        for (CElementInfo cElementInfo : this.model.getAllElements()) {
            this.getPackageContext(cElementInfo._package()).objectFactoryGenerator().populate(cElementInfo);
        }
        if (this.model.options.debugMode) {
            this.generateClassList();
        }
    }

    private void generateClassList() {
        try {
            JDefinedClass jc = this.codeModel.rootPackage()._class("JAXBDebug");
            JMethod m3 = jc.method(17, JAXBContext.class, "createContext");
            JVar $classLoader = m3.param(ClassLoader.class, "classLoader");
            m3._throws(JAXBException.class);
            JInvocation inv = this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance");
            m3.body()._return(inv);
            switch (this.model.strategy) {
                case INTF_AND_IMPL: {
                    StringBuilder buf = new StringBuilder();
                    for (PackageOutlineImpl po : this.packageContexts.values()) {
                        if (buf.length() > 0) {
                            buf.append(':');
                        }
                        buf.append(po._package().name());
                    }
                    inv.arg(buf.toString()).arg($classLoader);
                    break;
                }
                case BEAN_ONLY: {
                    for (ClassOutlineImpl cc : this.getClasses()) {
                        inv.arg(cc.implRef.dotclass());
                    }
                    for (PackageOutlineImpl po : this.packageContexts.values()) {
                        inv.arg(po.objectFactory().dotclass());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    @Override
    public JClassContainer getContainer(CClassInfoParent parent, Aspect aspect) {
        CClassInfoParent.Visitor<JClassContainer> v;
        switch (aspect) {
            case EXPOSED: {
                v = this.exposedContainerBuilder;
                break;
            }
            case IMPLEMENTATION: {
                v = this.implContainerBuilder;
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return parent.accept(v);
    }

    @Override
    public final JType resolve(CTypeRef ref, Aspect a) {
        return ((NType)ref.getTarget().getType()).toType(this, a);
    }

    public final JPackage[] getUsedPackages(Aspect aspect) {
        TreeSet<JPackage> s2 = new TreeSet<JPackage>();
        for (CClassInfo bean : this.model.beans().values()) {
            JClassContainer cont = this.getContainer(bean.parent(), aspect);
            if (!cont.isPackage()) continue;
            s2.add((JPackage)cont);
        }
        for (CElementInfo e : this.model.getElementMappings(null).values()) {
            s2.add(e._package());
        }
        return s2.toArray(new JPackage[s2.size()]);
    }

    @Override
    public ErrorReceiver getErrorReceiver() {
        return this.errorReceiver;
    }

    @Override
    public CodeModelClassFactory getClassFactory() {
        return this.codeModelClassFactory;
    }

    @Override
    public PackageOutlineImpl getPackageContext(JPackage p) {
        PackageOutlineImpl r = this.packageContexts.get(p);
        if (r == null) {
            r = new PackageOutlineImpl(this, this.model, p);
            this.packageContexts.put(p, r);
        }
        return r;
    }

    private ClassOutlineImpl generateClassDef(CClassInfo bean) {
        JDefinedClass implRef;
        ImplStructureStrategy.Result r = this.model.strategy.createClasses(this, bean);
        if (bean.getUserSpecifiedImplClass() != null) {
            JDefinedClass usr;
            try {
                usr = this.codeModel._class(bean.getUserSpecifiedImplClass());
                usr.hide();
            }
            catch (JClassAlreadyExistsException e) {
                usr = e.getExistingClass();
            }
            usr._extends(r.implementation);
            implRef = usr;
        } else {
            implRef = r.implementation;
        }
        return new ClassOutlineImpl(this, bean, r.exposed, r.implementation, implRef);
    }

    public Collection<ClassOutlineImpl> getClasses() {
        assert (this.model.beans().size() == this.classes.size());
        return this.classes.values();
    }

    @Override
    public ClassOutlineImpl getClazz(CClassInfo bean) {
        ClassOutlineImpl r = this.classes.get(bean);
        if (r == null) {
            r = this.generateClassDef(bean);
            this.classes.put(bean, r);
        }
        return r;
    }

    @Override
    public ElementOutlineImpl getElement(CElementInfo ei) {
        ElementOutlineImpl def = this.elements.get(ei);
        if (def == null && ei.hasClass()) {
            def = new ElementOutlineImpl(this, ei);
        }
        return def;
    }

    @Override
    public EnumOutline getEnum(CEnumLeafInfo eli) {
        return this.enums.get(eli);
    }

    @Override
    public Collection<EnumOutline> getEnums() {
        return this.enums.values();
    }

    @Override
    public Iterable<? extends PackageOutline> getAllPackageContexts() {
        return this.packageContexts.values();
    }

    @Override
    public FieldOutline getField(CPropertyInfo prop) {
        return this.fields.get(prop);
    }

    private void generateClassBody(ClassOutlineImpl cc) {
        Iterator<CClassInfo> subclasses;
        CClassInfo target = cc.target;
        String mostUsedNamespaceURI = cc._package().getMostUsedNamespaceURI();
        XmlTypeWriter xtw = cc.implClass.annotate2(XmlTypeWriter.class);
        this.writeTypeName(cc.target.getTypeName(), xtw, mostUsedNamespaceURI);
        if (this.model.options.target.isLaterThan(SpecVersion.V2_1) && (subclasses = cc.target.listSubclasses()).hasNext()) {
            XmlSeeAlsoWriter saw = cc.implClass.annotate2(XmlSeeAlsoWriter.class);
            while (subclasses.hasNext()) {
                CClassInfo s2 = subclasses.next();
                saw.value(this.getClazz((CClassInfo)s2).implRef);
            }
        }
        if (target.isElement()) {
            String namespaceURI = target.getElementName().getNamespaceURI();
            String localPart = target.getElementName().getLocalPart();
            XmlRootElementWriter xrew = cc.implClass.annotate2(XmlRootElementWriter.class);
            xrew.name(localPart);
            if (!namespaceURI.equals(mostUsedNamespaceURI)) {
                xrew.namespace(namespaceURI);
            }
        }
        if (target.isOrdered()) {
            for (CPropertyInfo p : target.getProperties()) {
                if (p instanceof CAttributePropertyInfo || p instanceof CReferencePropertyInfo && ((CReferencePropertyInfo)p).isDummy()) continue;
                xtw.propOrder(p.getName(false));
            }
        } else {
            xtw.getAnnotationUse().paramArray("propOrder");
        }
        for (CPropertyInfo prop : target.getProperties()) {
            this.generateFieldDecl(cc, prop);
        }
        if (target.declaresAttributeWildcard()) {
            this.generateAttributeWildcard(cc);
        }
        cc.ref.javadoc().append(target.javadoc);
        cc._package().objectFactoryGenerator().populate(cc);
    }

    private void writeTypeName(QName typeName, XmlTypeWriter xtw, String mostUsedNamespaceURI) {
        if (typeName == null) {
            xtw.name("");
        } else {
            xtw.name(typeName.getLocalPart());
            String typeNameURI = typeName.getNamespaceURI();
            if (!typeNameURI.equals(mostUsedNamespaceURI)) {
                xtw.namespace(typeNameURI);
            }
        }
    }

    private void generateAttributeWildcard(ClassOutlineImpl cc) {
        String FIELD_NAME = "otherAttributes";
        String METHOD_SEED = this.model.getNameConverter().toClassName(FIELD_NAME);
        JClass mapType = this.codeModel.ref(Map.class).narrow(QName.class, String.class);
        JClass mapImpl = this.codeModel.ref(HashMap.class).narrow(QName.class, String.class);
        JFieldVar $ref = cc.implClass.field(4, mapType, FIELD_NAME, (JExpression)JExpr._new(mapImpl));
        $ref.annotate2(XmlAnyAttributeWriter.class);
        MethodWriter writer = cc.createMethodWriter();
        JMethod $get = writer.declareMethod(mapType, "get" + METHOD_SEED);
        $get.javadoc().append("Gets a map that contains attributes that aren't bound to any typed property on this class.\n\n<p>\nthe map is keyed by the name of the attribute and \nthe value is the string value of the attribute.\n\nthe map returned by this method is live, and you can add new attribute\nby updating the map directly. Because of this design, there's no setter.\n");
        $get.javadoc().addReturn().append("always non-null");
        $get.body()._return($ref);
    }

    private EnumOutline generateEnumDef(CEnumLeafInfo e) {
        JDefinedClass type = this.getClassFactory().createClass(this.getContainer(e.parent, Aspect.EXPOSED), e.shortName, e.getLocator(), ClassType.ENUM);
        type.javadoc().append(e.javadoc);
        return new EnumOutline(e, type){

            @Override
            @NotNull
            public Outline parent() {
                return BeanGenerator.this;
            }
        };
    }

    private void generateEnumBody(EnumOutline eo) {
        JDefinedClass type = eo.clazz;
        CEnumLeafInfo e = eo.target;
        XmlTypeWriter xtw = type.annotate2(XmlTypeWriter.class);
        this.writeTypeName(e.getTypeName(), xtw, eo._package().getMostUsedNamespaceURI());
        JCodeModel cModel = this.model.codeModel;
        JType baseExposedType = e.base.toType(this, Aspect.EXPOSED).unboxify();
        JType baseImplType = e.base.toType(this, Aspect.IMPLEMENTATION).unboxify();
        XmlEnumWriter xew = type.annotate2(XmlEnumWriter.class);
        xew.value(baseExposedType);
        boolean needsValue = e.needsValueField();
        HashSet<String> enumFieldNames = new HashSet<String>();
        for (CEnumConstant mem : e.members) {
            String constName = mem.getName();
            if (!JJavaName.isJavaIdentifier(constName)) {
                this.getErrorReceiver().error(e.getLocator(), Messages.ERR_UNUSABLE_NAME.format(mem.getLexicalValue(), constName));
            }
            if (!enumFieldNames.add(constName)) {
                this.getErrorReceiver().error(e.getLocator(), Messages.ERR_NAME_COLLISION.format(constName));
            }
            JEnumConstant constRef = type.enumConstant(constName);
            if (needsValue) {
                constRef.arg(e.base.createConstant(this, new XmlString(mem.getLexicalValue())));
            }
            if (!mem.getLexicalValue().equals(constName)) {
                constRef.annotate2(XmlEnumValueWriter.class).value(mem.getLexicalValue());
            }
            if (mem.javadoc != null) {
                constRef.javadoc().append(mem.javadoc);
            }
            eo.constants.add(new EnumConstantOutline(mem, constRef){});
        }
        if (needsValue) {
            JFieldVar $value = type.field(12, baseExposedType, "value");
            type.method(1, baseExposedType, "value").body()._return($value);
            JMethod m3 = type.constructor(0);
            m3.body().assign($value, m3.param(baseImplType, "v"));
            m3 = type.method(17, type, "fromValue");
            JVar $v = m3.param(baseExposedType, "v");
            JForEach fe = m3.body().forEach(type, "c", type.staticInvoke("values"));
            JExpression eq = baseExposedType.isPrimitive() ? fe.var().ref($value).eq($v) : fe.var().ref($value).invoke("equals").arg($v);
            fe.body()._if(eq)._then()._return(fe.var());
            JInvocation ex = JExpr._new(cModel.ref(IllegalArgumentException.class));
            JExpressionImpl strForm = baseExposedType.isPrimitive() ? cModel.ref(String.class).staticInvoke("valueOf").arg($v) : (baseExposedType == cModel.ref(String.class) ? $v : $v.invoke("toString"));
            m3.body()._throw(ex.arg(strForm));
        } else {
            type.method(1, String.class, "value").body()._return(JExpr.invoke("name"));
            JMethod m4 = type.method(17, type, "fromValue");
            m4.body()._return(JExpr.invoke("valueOf").arg(m4.param(String.class, "v")));
        }
    }

    private FieldOutline generateFieldDecl(ClassOutlineImpl cc, CPropertyInfo prop) {
        FieldRenderer fr = prop.realization;
        if (fr == null) {
            fr = this.model.options.getFieldRendererFactory().getDefault();
        }
        FieldOutline field = fr.generate(cc, prop);
        this.fields.put(prop, field);
        return field;
    }

    public final void generateAdapterIfNecessary(CPropertyInfo prop, JAnnotatable field) {
        CAdapter adapter = prop.getAdapter();
        if (adapter != null) {
            if (adapter.getAdapterIfKnown() == SwaRefAdapter.class) {
                field.annotate(XmlAttachmentRef.class);
            } else {
                XmlJavaTypeAdapterWriter xjtw = field.annotate2(XmlJavaTypeAdapterWriter.class);
                xjtw.value(((NClass)adapter.adapterType).toType(this, Aspect.EXPOSED));
            }
        }
        switch (prop.id()) {
            case ID: {
                field.annotate(XmlID.class);
                break;
            }
            case IDREF: {
                field.annotate(XmlIDREF.class);
            }
        }
        if (prop.getExpectedMimeType() != null) {
            field.annotate2(XmlMimeTypeWriter.class).value(prop.getExpectedMimeType().toString());
        }
    }

    @Override
    public final JClass addRuntime(Class clazz) {
        JClass g2 = this.generatedRuntime.get(clazz);
        if (g2 == null) {
            JPackage implPkg = this.getUsedPackages(Aspect.IMPLEMENTATION)[0].subPackage("runtime");
            g2 = this.generateStaticClass(clazz, implPkg);
            this.generatedRuntime.put(clazz, g2);
        }
        return g2;
    }

    public JClass generateStaticClass(Class src, JPackage out) {
        String shortName = this.getShortName(src.getName());
        URL res = src.getResource(shortName + ".java");
        if (res == null) {
            res = src.getResource(shortName + ".java_");
        }
        if (res == null) {
            throw new InternalError("Unable to load source code of " + src.getName() + " as a resource");
        }
        JStaticJavaFile sjf = new JStaticJavaFile(out, shortName, res, null);
        out.addResourceFile(sjf);
        return sjf.getJClass();
    }

    private String getShortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

