/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class HtmlWriter
extends PrintWriter {
    protected final String htmlFilename;
    protected String winTitle;
    public static final String fileseparator = "/";
    protected Configuration configuration;
    protected boolean memberDetailsListPrinted;
    protected final String[] packageTableHeader;
    protected final String useTableSummary;
    protected final String modifierTypeHeader;
    public final Content overviewLabel;
    public final Content defaultPackageLabel;
    public final Content packageLabel;
    public final Content useLabel;
    public final Content prevLabel;
    public final Content nextLabel;
    public final Content prevclassLabel;
    public final Content nextclassLabel;
    public final Content summaryLabel;
    public final Content detailLabel;
    public final Content framesLabel;
    public final Content noframesLabel;
    public final Content treeLabel;
    public final Content classLabel;
    public final Content deprecatedLabel;
    public final Content deprecatedPhrase;
    public final Content allclassesLabel;
    public final Content indexLabel;
    public final Content helpLabel;
    public final Content seeLabel;
    public final Content descriptionLabel;
    public final Content prevpackageLabel;
    public final Content nextpackageLabel;
    public final Content packagesLabel;
    public final Content methodDetailsLabel;
    public final Content annotationTypeDetailsLabel;
    public final Content fieldDetailsLabel;
    public final Content propertyDetailsLabel;
    public final Content constructorDetailsLabel;
    public final Content enumConstantsDetailsLabel;
    public final Content specifiedByLabel;
    public final Content overridesLabel;
    public final Content descfrmClassLabel;
    public final Content descfrmInterfaceLabel;

    public HtmlWriter(Configuration configuration, String string, String string2, String string3) throws IOException, UnsupportedEncodingException {
        super(Util.genWriter(configuration, string, string2, string3));
        this.configuration = configuration;
        this.htmlFilename = string2;
        this.memberDetailsListPrinted = false;
        this.packageTableHeader = new String[]{configuration.getText("doclet.Package"), configuration.getText("doclet.Description")};
        this.useTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.packages"));
        this.modifierTypeHeader = configuration.getText("doclet.0_and_1", configuration.getText("doclet.Modifier"), configuration.getText("doclet.Type"));
        this.overviewLabel = this.getResource("doclet.Overview");
        this.defaultPackageLabel = new RawHtml("&lt;Unnamed&gt;");
        this.packageLabel = this.getResource("doclet.Package");
        this.useLabel = this.getResource("doclet.navClassUse");
        this.prevLabel = this.getResource("doclet.Prev");
        this.nextLabel = this.getResource("doclet.Next");
        this.prevclassLabel = this.getResource("doclet.Prev_Class");
        this.nextclassLabel = this.getResource("doclet.Next_Class");
        this.summaryLabel = this.getResource("doclet.Summary");
        this.detailLabel = this.getResource("doclet.Detail");
        this.framesLabel = this.getResource("doclet.Frames");
        this.noframesLabel = this.getResource("doclet.No_Frames");
        this.treeLabel = this.getResource("doclet.Tree");
        this.classLabel = this.getResource("doclet.Class");
        this.deprecatedLabel = this.getResource("doclet.navDeprecated");
        this.deprecatedPhrase = this.getResource("doclet.Deprecated");
        this.allclassesLabel = this.getResource("doclet.All_Classes");
        this.indexLabel = this.getResource("doclet.Index");
        this.helpLabel = this.getResource("doclet.Help");
        this.seeLabel = this.getResource("doclet.See");
        this.descriptionLabel = this.getResource("doclet.Description");
        this.prevpackageLabel = this.getResource("doclet.Prev_Package");
        this.nextpackageLabel = this.getResource("doclet.Next_Package");
        this.packagesLabel = this.getResource("doclet.Packages");
        this.methodDetailsLabel = this.getResource("doclet.Method_Detail");
        this.annotationTypeDetailsLabel = this.getResource("doclet.Annotation_Type_Member_Detail");
        this.fieldDetailsLabel = this.getResource("doclet.Field_Detail");
        this.propertyDetailsLabel = this.getResource("doclet.Property_Detail");
        this.constructorDetailsLabel = this.getResource("doclet.Constructor_Detail");
        this.enumConstantsDetailsLabel = this.getResource("doclet.Enum_Constant_Detail");
        this.specifiedByLabel = this.getResource("doclet.Specified_By");
        this.overridesLabel = this.getResource("doclet.Overrides");
        this.descfrmClassLabel = this.getResource("doclet.Description_From_Class");
        this.descfrmInterfaceLabel = this.getResource("doclet.Description_From_Interface");
    }

    public Content getResource(String string) {
        return new StringContent(this.configuration.getText(string));
    }

    public Content getResource(String string, String string2) {
        return new RawHtml(this.configuration.getText(string, string2));
    }

    public Content getResource(String string, String string2, String string3) {
        return new RawHtml(this.configuration.getText(string, string2, string3));
    }

    public void html() {
        this.println("<HTML lang=\"" + this.configuration.getLocale().getLanguage() + "\">");
    }

    public void htmlEnd() {
        this.println("</HTML>");
    }

    protected void printWinTitleScript(String string) {
        if (string != null && string.length() > 0) {
            this.script();
            this.println("function windowTitle()");
            this.println("{");
            this.println("    if (location.href.indexOf('is-external=true') == -1) {");
            this.println("        parent.document.title=\"" + string + "\";");
            this.println("    }");
            this.println("}");
            this.scriptEnd();
            this.noScript();
            this.noScriptEnd();
        }
    }

    protected HtmlTree getWinTitleScript() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SCRIPT);
        if (this.winTitle != null && this.winTitle.length() > 0) {
            htmlTree.addAttr(HtmlAttr.TYPE, "text/javascript");
            String string = "<!--" + DocletConstants.NL + "    if (location.href.indexOf('is-external=true') == -1) {" + DocletConstants.NL + "        parent.document.title=\"" + HtmlWriter.escapeJavaScriptChars(this.winTitle) + "\";" + DocletConstants.NL + "    }" + DocletConstants.NL + "//-->" + DocletConstants.NL;
            RawHtml rawHtml = new RawHtml(string);
            htmlTree.addContent(rawHtml);
        }
        return htmlTree;
    }

    private static String escapeJavaScriptChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        stringBuilder.append(String.format("\\u%04X", c));
                        continue block10;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected Content getFramesetJavaScript() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SCRIPT);
        htmlTree.addAttr(HtmlAttr.TYPE, "text/javascript");
        String string = DocletConstants.NL + "    targetPage = \"\" + window.location.search;" + DocletConstants.NL + "    if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "        targetPage = targetPage.substring(1);" + DocletConstants.NL + "    if (targetPage.indexOf(\":\") != -1 || (targetPage != \"\" && !validURL(targetPage)))" + DocletConstants.NL + "        targetPage = \"undefined\";" + DocletConstants.NL + "    function validURL(url) {" + DocletConstants.NL + "        try {" + DocletConstants.NL + "            url = decodeURIComponent(url);" + DocletConstants.NL + "        }" + DocletConstants.NL + "        catch (error) {" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        }" + DocletConstants.NL + "        var pos = url.indexOf(\".html\");" + DocletConstants.NL + "        if (pos == -1 || pos != url.length - 5)" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        var allowNumber = false;" + DocletConstants.NL + "        var allowSep = false;" + DocletConstants.NL + "        var seenDot = false;" + DocletConstants.NL + "        for (var i = 0; i < url.length - 5; i++) {" + DocletConstants.NL + "            var ch = url.charAt(i);" + DocletConstants.NL + "            if ('a' <= ch && ch <= 'z' ||" + DocletConstants.NL + "                    'A' <= ch && ch <= 'Z' ||" + DocletConstants.NL + "                    ch == '$' ||" + DocletConstants.NL + "                    ch == '_' ||" + DocletConstants.NL + "                    ch.charCodeAt(0) > 127) {" + DocletConstants.NL + "                allowNumber = true;" + DocletConstants.NL + "                allowSep = true;" + DocletConstants.NL + "            } else if ('0' <= ch && ch <= '9'" + DocletConstants.NL + "                    || ch == '-') {" + DocletConstants.NL + "                if (!allowNumber)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else if (ch == '/' || ch == '.') {" + DocletConstants.NL + "                if (!allowSep)" + DocletConstants.NL + "                    return false;" + DocletConstants.NL + "                allowNumber = false;" + DocletConstants.NL + "                allowSep = false;" + DocletConstants.NL + "                if (ch == '.')" + DocletConstants.NL + "                     seenDot = true;" + DocletConstants.NL + "                if (ch == '/' && seenDot)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else {" + DocletConstants.NL + "                return false;" + DocletConstants.NL + "            }" + DocletConstants.NL + "        }" + DocletConstants.NL + "        return true;" + DocletConstants.NL + "    }" + DocletConstants.NL + "    function loadFrames() {" + DocletConstants.NL + "        if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "             top.classFrame.location = top.targetPage;" + DocletConstants.NL + "    }" + DocletConstants.NL;
        RawHtml rawHtml = new RawHtml(string);
        htmlTree.addContent(rawHtml);
        return htmlTree;
    }

    public void script() {
        this.println("<SCRIPT type=\"text/javascript\">");
    }

    public void scriptEnd() {
        this.println("</SCRIPT>");
    }

    public void noScript() {
        this.println("<NOSCRIPT>");
    }

    public void noScriptEnd() {
        this.println("</NOSCRIPT>");
    }

    protected String getWindowTitleOnload() {
        if (this.winTitle != null && this.winTitle.length() > 0) {
            return " onload=\"windowTitle();\"";
        }
        return "";
    }

    public void body(String string, boolean bl) {
        this.print("<BODY BGCOLOR=\"" + string + "\"");
        if (bl) {
            this.print(this.getWindowTitleOnload());
        }
        this.println(">");
    }

    public HtmlTree getBody(boolean bl, String string) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.BODY);
        this.winTitle = string;
        if (bl) {
            htmlTree.addContent(this.getWinTitleScript());
            HtmlTree htmlTree2 = HtmlTree.NOSCRIPT(HtmlTree.DIV(this.getResource("doclet.No_Script_Message")));
            htmlTree.addContent(htmlTree2);
        }
        return htmlTree;
    }

    public void bodyEnd() {
        this.println("</BODY>");
    }

    public void title() {
        this.println("<TITLE>");
    }

    public void title(String string) {
        this.winTitle = string;
        this.title();
    }

    public HtmlTree getTitle() {
        HtmlTree htmlTree = HtmlTree.TITLE(new StringContent(this.winTitle));
        return htmlTree;
    }

    public void titleEnd() {
        this.println("</TITLE>");
    }

    public void ul() {
        this.println("<UL>");
    }

    public void ulEnd() {
        this.println("</UL>");
    }

    public void li() {
        this.print("<LI>");
    }

    public void li(String string) {
        this.print("<LI TYPE=\"" + string + "\">");
    }

    public void h1() {
        this.println("<H1>");
    }

    public void h1End() {
        this.println("</H1>");
    }

    public void h1(String string) {
        this.h1();
        this.println(string);
        this.h1End();
    }

    public void h2() {
        this.println("<H2>");
    }

    public void h2(String string) {
        this.h2();
        this.println(string);
        this.h2End();
    }

    public void h2End() {
        this.println("</H2>");
    }

    public void h3() {
        this.println("<H3>");
    }

    public void h3(String string) {
        this.h3();
        this.println(string);
        this.h3End();
    }

    public void h3End() {
        this.println("</H3>");
    }

    public void h4() {
        this.println("<H4>");
    }

    public void h4End() {
        this.println("</H4>");
    }

    public void h4(String string) {
        this.h4();
        this.println(string);
        this.h4End();
    }

    public void h5() {
        this.println("<H5>");
    }

    public void h5End() {
        this.println("</H5>");
    }

    public void img(String string, String string2, int n, int n2) {
        this.println("<IMG SRC=\"images/" + string + ".gif\"" + " WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\" ALT=\"" + string2 + "\">");
    }

    public void menu() {
        this.println("<MENU>");
    }

    public void menuEnd() {
        this.println("</MENU>");
    }

    public void pre() {
        this.println("<PRE>");
    }

    public void preNoNewLine() {
        this.print("<PRE>");
    }

    public void preEnd() {
        this.println("</PRE>");
    }

    public void hr() {
        this.println("<HR>");
    }

    public void hr(int n, int n2) {
        this.println("<HR SIZE=\"" + n + "\" WIDTH=\"" + n2 + "%\">");
    }

    public void hr(int n, String string) {
        this.println("<HR SIZE=\"" + n + "\" NOSHADE>");
    }

    public String getStrong() {
        return "<STRONG>";
    }

    public String getStrongEnd() {
        return "</STRONG>";
    }

    public void strong() {
        this.print("<STRONG>");
    }

    public void strongEnd() {
        this.print("</STRONG>");
    }

    public void strong(String string) {
        this.strong();
        this.print(string);
        this.strongEnd();
    }

    public void italics(String string) {
        this.print("<I>");
        this.print(string);
        this.println("</I>");
    }

    public String italicsText(String string) {
        return "<i>" + string + "</i>";
    }

    public String codeText(String string) {
        return "<code>" + string + "</code>";
    }

    public void space() {
        this.print("&nbsp;");
    }

    public Content getSpace() {
        return RawHtml.nbsp;
    }

    public void dl() {
        this.println("<DL>");
    }

    public void dlEnd() {
        this.println("</DL>");
    }

    public void dt() {
        this.print("<DT>");
    }

    public void dtEnd() {
        this.print("</DT>");
    }

    public void dd() {
        this.print("<DD>");
    }

    public void ddEnd() {
        this.println("</DD>");
    }

    public void sup() {
        this.println("<SUP>");
    }

    public void supEnd() {
        this.println("</SUP>");
    }

    public void font(String string) {
        this.println("<FONT SIZE=\"" + string + "\">");
    }

    public void fontNoNewLine(String string) {
        this.print("<FONT SIZE=\"" + string + "\">");
    }

    public void fontStyle(String string) {
        this.print("<FONT CLASS=\"" + string + "\">");
    }

    public void fontSizeStyle(String string, String string2) {
        this.println("<FONT size=\"" + string + "\" CLASS=\"" + string2 + "\">");
    }

    public void fontEnd() {
        this.print("</FONT>");
    }

    public String getFontColor(String string) {
        return "<FONT COLOR=\"" + string + "\">";
    }

    public String getFontEnd() {
        return "</FONT>";
    }

    public void center() {
        this.println("<CENTER>");
    }

    public void centerEnd() {
        this.println("</CENTER>");
    }

    public void aName(String string) {
        this.print("<A NAME=\"" + string + "\">");
    }

    public void aEnd() {
        this.print("</A>");
    }

    public void italic() {
        this.print("<I>");
    }

    public void italicEnd() {
        this.print("</I>");
    }

    public void anchor(String string, String string2) {
        this.aName(string);
        this.print(string2);
        this.aEnd();
    }

    public void anchor(String string) {
        this.anchor(string, "<!-- -->");
    }

    public void p() {
        this.println();
        this.println("<P>");
    }

    public void pEnd() {
        this.println();
        this.println("</P>");
    }

    public void br() {
        this.println();
        this.println("<BR>");
    }

    public void address() {
        this.println("<ADDRESS>");
    }

    public void addressEnd() {
        this.println("</ADDRESS>");
    }

    public void head() {
        this.println("<HEAD>");
    }

    public void headEnd() {
        this.println("</HEAD>");
    }

    public void code() {
        this.print("<CODE>");
    }

    public void codeEnd() {
        this.print("</CODE>");
    }

    public void em() {
        this.println("<EM>");
    }

    public void emEnd() {
        this.println("</EM>");
    }

    public void table(int n, String string, int n2, int n3) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + n + "\" WIDTH=\"" + string + "\" CELLPADDING=\"" + n2 + "\" CELLSPACING=\"" + n3 + "\" SUMMARY=\"\">");
    }

    public void table(int n, String string, int n2, int n3, String string2) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + n + "\" WIDTH=\"" + string + "\" CELLPADDING=\"" + n2 + "\" CELLSPACING=\"" + n3 + "\" SUMMARY=\"" + string2 + "\">");
    }

    public void table(int n, int n2, int n3) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + n + "\" CELLPADDING=\"" + n2 + "\" CELLSPACING=\"" + n3 + "\" SUMMARY=\"\">");
    }

    public void table(int n, int n2, int n3, String string) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + n + "\" CELLPADDING=\"" + n2 + "\" CELLSPACING=\"" + n3 + "\" SUMMARY=\"" + string + "\">");
    }

    public void table(int n, String string) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + n + "\" WIDTH=\"" + string + "\" SUMMARY=\"\">");
    }

    public void table() {
        this.table(0, "100%");
    }

    public void tableEnd() {
        this.println("</TABLE>");
    }

    public void tr() {
        this.println("<TR>");
    }

    public void trEnd() {
        this.println("</TR>");
    }

    public void td() {
        this.print("<TD>");
    }

    public void tdNowrap() {
        this.print("<TD NOWRAP>");
    }

    public void tdWidth(String string) {
        this.print("<TD WIDTH=\"" + string + "\">");
    }

    public void tdEnd() {
        this.println("</TD>");
    }

    public void link(String string) {
        this.println("<LINK " + string + ">");
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println("-->");
    }

    public void captionStyle(String string) {
        this.println("<CAPTION CLASS=\"" + string + "\">");
    }

    public void captionEnd() {
        this.println("</CAPTION>");
    }

    public void trBgcolorStyle(String string, String string2) {
        this.println("<TR BGCOLOR=\"" + string + "\" CLASS=\"" + string2 + "\">");
    }

    public void trBgcolor(String string) {
        this.println("<TR BGCOLOR=\"" + string + "\">");
    }

    public void trAlignVAlign(String string, String string2) {
        this.println("<TR ALIGN=\"" + string + "\" VALIGN=\"" + string2 + "\">");
    }

    public void thAlign(String string) {
        this.print("<TH ALIGN=\"" + string + "\">");
    }

    public void thScopeNoWrap(String string, String string2) {
        this.print("<TH CLASS=\"" + string + "\" SCOPE=\"" + string2 + "\" NOWRAP>");
    }

    public String getModifierTypeHeader() {
        return this.modifierTypeHeader;
    }

    public void thAlignColspan(String string, int n) {
        this.print("<TH ALIGN=\"" + string + "\" COLSPAN=\"" + n + "\">");
    }

    public void thAlignNowrap(String string) {
        this.print("<TH ALIGN=\"" + string + "\" NOWRAP>");
    }

    public void thEnd() {
        this.println("</TH>");
    }

    public void tdColspan(int n) {
        this.print("<TD COLSPAN=" + n + ">");
    }

    public void tdBgcolorStyle(String string, String string2) {
        this.print("<TD BGCOLOR=\"" + string + "\" CLASS=\"" + string2 + "\">");
    }

    public void tdColspanBgcolorStyle(int n, String string, String string2) {
        this.print("<TD COLSPAN=" + n + " BGCOLOR=\"" + string + "\" CLASS=\"" + string2 + "\">");
    }

    public void tdAlign(String string) {
        this.print("<TD ALIGN=\"" + string + "\">");
    }

    public void tdVAlignClass(String string, String string2) {
        this.print("<TD VALIGN=\"" + string + "\" CLASS=\"" + string2 + "\">");
    }

    public void tdVAlign(String string) {
        this.print("<TD VALIGN=\"" + string + "\">");
    }

    public void tdAlignVAlign(String string, String string2) {
        this.print("<TD ALIGN=\"" + string + "\" VALIGN=\"" + string2 + "\">");
    }

    public void tdAlignRowspan(String string, int n) {
        this.print("<TD ALIGN=\"" + string + "\" ROWSPAN=" + n + ">");
    }

    public void tdAlignVAlignRowspan(String string, String string2, int n) {
        this.print("<TD ALIGN=\"" + string + "\" VALIGN=\"" + string2 + "\" ROWSPAN=" + n + ">");
    }

    public void blockquote() {
        this.println("<BLOCKQUOTE>");
    }

    public void blockquoteEnd() {
        this.println("</BLOCKQUOTE>");
    }

    public String getCode() {
        return "<code>";
    }

    public String getCodeEnd() {
        return "</code>";
    }

    public void noFrames() {
        this.println("<NOFRAMES>");
    }

    public void noFramesEnd() {
        this.println("</NOFRAMES>");
    }
}

