/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.DocType;
import com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final Content NEW_LINE = new RawHtml(DocletConstants.NL);
    private static String relativePath = "";

    private SourceToHTMLConverter() {
    }

    public static void convertRoot(ConfigurationImpl configurationImpl, RootDoc rootDoc, String string) {
        if (rootDoc == null || string == null) {
            return;
        }
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (configurationImpl.nodeprecated && Util.isDeprecated(packageDocArray[i])) continue;
            SourceToHTMLConverter.convertPackage(configurationImpl, packageDocArray[i], string);
        }
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (configurationImpl.nodeprecated && (Util.isDeprecated(classDocArray[i]) || Util.isDeprecated(classDocArray[i].containingPackage()))) continue;
            SourceToHTMLConverter.convertClass(configurationImpl, classDocArray[i], SourceToHTMLConverter.getPackageOutputDir(string, classDocArray[i].containingPackage()));
        }
    }

    public static void convertPackage(ConfigurationImpl configurationImpl, PackageDoc packageDoc, String string) {
        if (packageDoc == null || string == null) {
            return;
        }
        String string2 = SourceToHTMLConverter.getPackageOutputDir(string, packageDoc);
        ClassDoc[] classDocArray = packageDoc.allClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (configurationImpl.nodeprecated && Util.isDeprecated(classDocArray[i])) continue;
            SourceToHTMLConverter.convertClass(configurationImpl, classDocArray[i], string2);
        }
    }

    private static String getPackageOutputDir(String string, PackageDoc packageDoc) {
        return string + File.separator + DirectoryManager.getDirectoryPath(packageDoc) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertClass(ConfigurationImpl configurationImpl, ClassDoc classDoc, String string) {
        if (classDoc == null || string == null) {
            return;
        }
        try {
            Reader reader;
            Object object;
            SourcePosition sourcePosition = classDoc.position();
            if (sourcePosition == null) {
                return;
            }
            if (sourcePosition instanceof SourcePositionImpl) {
                object = ((SourcePositionImpl)sourcePosition).fileObject();
                if (object == null) {
                    return;
                }
                reader = object.openReader(true);
            } else {
                object = sourcePosition.file();
                if (object == null) {
                    return;
                }
                reader = new FileReader((File)object);
            }
            object = new LineNumberReader(reader);
            int n = 1;
            relativePath = DirectoryManager.getRelativePath("src-html/") + DirectoryManager.getRelativePath(classDoc.containingPackage());
            Content content = SourceToHTMLConverter.getHeader();
            HtmlTree htmlTree = new HtmlTree(HtmlTag.PRE);
            try {
                String string2;
                while ((string2 = ((LineNumberReader)object).readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(htmlTree, n);
                    SourceToHTMLConverter.addLine(htmlTree, string2, configurationImpl.sourcetab, n);
                    ++n;
                }
            }
            finally {
                ((BufferedReader)object).close();
            }
            SourceToHTMLConverter.addBlankLines(htmlTree);
            HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.sourceContainer, htmlTree);
            content.addContent(htmlTree2);
            SourceToHTMLConverter.writeToFile(content, string, classDoc.name(), configurationImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeToFile(Content content, String string, String string2, ConfigurationImpl configurationImpl) throws IOException {
        DocType docType = DocType.Transitional();
        HtmlTree htmlTree = new HtmlTree(HtmlTag.HEAD);
        ((Content)htmlTree).addContent(HtmlTree.TITLE(new StringContent(configurationImpl.getText("doclet.Window_Source_title"))));
        ((Content)htmlTree).addContent(SourceToHTMLConverter.getStyleSheetProperties(configurationImpl));
        HtmlTree htmlTree2 = HtmlTree.HTML(configurationImpl.getLocale().getLanguage(), htmlTree, content);
        HtmlDocument htmlDocument = new HtmlDocument(docType, htmlTree2);
        File file = new File(string);
        file.mkdirs();
        File file2 = new File(file, string2 + ".html");
        configurationImpl.message.notice("doclet.Generating_0", file2.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write(htmlDocument.toString());
        bufferedWriter.close();
        fileOutputStream.close();
    }

    public static HtmlTree getStyleSheetProperties(ConfigurationImpl configurationImpl) {
        Object object;
        String string;
        String string2 = configurationImpl.stylesheetfile;
        string2 = string2.length() > 0 ? ((string = ((File)(object = new File(string2))).getParent()) == null ? string2 : string2.substring(string.length() + 1)) : "stylesheet.css";
        string2 = relativePath + string2;
        object = HtmlTree.LINK("stylesheet", "text/css", string2, "Style");
        return object;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content content, int n) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SPAN);
        htmlTree.addStyle(HtmlStyle.sourceLineNo);
        if (n < 10) {
            htmlTree.addContent("00" + Integer.toString(n));
        } else if (n < 100) {
            htmlTree.addContent("0" + Integer.toString(n));
        } else {
            htmlTree.addContent(Integer.toString(n));
        }
        content.addContent(htmlTree);
    }

    private static void addLine(Content content, String string, int n, int n2) {
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(Util.escapeHtmlChars(string));
            Util.replaceTabs(n, stringBuilder);
            content.addContent(new RawHtml(stringBuilder.toString()));
            HtmlTree htmlTree = HtmlTree.A_NAME("line." + Integer.toString(n2));
            content.addContent(htmlTree);
            content.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content content) {
        for (int i = 0; i < 60; ++i) {
            content.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Doc doc) {
        return "line." + doc.position().line();
    }
}

