/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Type {
    protected Type() {
    }

    public boolean isObject() {
        return false;
    }

    public abstract <R, D> R accept(Visitor<R, D> var1, D var2);

    protected static void append(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
        stringBuilder.append(string);
        String string3 = "";
        for (Type type : list) {
            stringBuilder.append(string3);
            stringBuilder.append(type);
            string3 = ", ";
        }
        stringBuilder.append(string2);
    }

    protected static void appendIfNotEmpty(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
        if (list != null && list.size() > 0) {
            Type.append(stringBuilder, string, list, string2);
        }
    }

    public static class ArrayType
    extends Type {
        public final Type elemType;

        public ArrayType(Type type) {
            this.elemType = type;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitArrayType(this, d);
        }

        public String toString() {
            return this.elemType + "[]";
        }
    }

    public static class ClassSigType
    extends Type {
        public final List<TypeParamType> typeParamTypes;
        public final Type superclassType;
        public final List<Type> superinterfaceTypes;

        public ClassSigType(List<TypeParamType> list, Type type, List<Type> list2) {
            this.typeParamTypes = list;
            this.superclassType = type;
            this.superinterfaceTypes = list2;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitClassSigType(this, d);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            ClassSigType.appendIfNotEmpty(stringBuilder, "<", this.typeParamTypes, ">");
            if (this.superclassType != null) {
                stringBuilder.append(" extends ");
                stringBuilder.append(this.superclassType);
            }
            ClassSigType.appendIfNotEmpty(stringBuilder, " implements ", this.superinterfaceTypes, "");
            return stringBuilder.toString();
        }
    }

    public static class ClassType
    extends Type {
        public final ClassType outerType;
        public final String name;
        public final List<Type> typeArgs;

        public ClassType(ClassType classType, String string, List<Type> list) {
            this.outerType = classType;
            this.name = string;
            this.typeArgs = list;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitClassType(this, d);
        }

        public String getBinaryName() {
            if (this.outerType == null) {
                return this.name;
            }
            return this.outerType.getBinaryName() + "$" + this.name;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.outerType != null) {
                stringBuilder.append(this.outerType);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.name);
            ClassType.appendIfNotEmpty(stringBuilder, "<", this.typeArgs, ">");
            return stringBuilder.toString();
        }

        @Override
        public boolean isObject() {
            return this.outerType == null && this.name.equals("java/lang/Object") && (this.typeArgs == null || this.typeArgs.isEmpty());
        }
    }

    public static class MethodType
    extends Type {
        public final List<? extends TypeParamType> typeParamTypes;
        public final List<? extends Type> paramTypes;
        public final Type returnType;
        public final List<? extends Type> throwsTypes;

        public MethodType(List<? extends Type> list, Type type) {
            this(null, list, type, null);
        }

        public MethodType(List<? extends TypeParamType> list, List<? extends Type> list2, Type type, List<? extends Type> list3) {
            this.typeParamTypes = list;
            this.paramTypes = list2;
            this.returnType = type;
            this.throwsTypes = list3;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitMethodType(this, d);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            MethodType.appendIfNotEmpty(stringBuilder, "<", this.typeParamTypes, "> ");
            stringBuilder.append(this.returnType);
            MethodType.append(stringBuilder, " (", this.paramTypes, ")");
            MethodType.appendIfNotEmpty(stringBuilder, " throws ", this.throwsTypes, "");
            return stringBuilder.toString();
        }
    }

    public static class SimpleType
    extends Type {
        private static final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short", "void"));
        public final String name;

        public SimpleType(String string) {
            this.name = string;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitSimpleType(this, d);
        }

        public boolean isPrimitiveType() {
            return primitiveTypes.contains(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TypeParamType
    extends Type {
        public final String name;
        public final Type classBound;
        public final List<Type> interfaceBounds;

        public TypeParamType(String string, Type type, List<Type> list) {
            this.name = string;
            this.classBound = type;
            this.interfaceBounds = list;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitTypeParamType(this, d);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            String string = " extends ";
            if (this.classBound != null) {
                stringBuilder.append(string);
                stringBuilder.append(this.classBound);
                string = " & ";
            }
            if (this.interfaceBounds != null) {
                for (Type type : this.interfaceBounds) {
                    stringBuilder.append(string);
                    stringBuilder.append(type);
                    string = " & ";
                }
            }
            return stringBuilder.toString();
        }
    }

    public static interface Visitor<R, P> {
        public R visitSimpleType(SimpleType var1, P var2);

        public R visitArrayType(ArrayType var1, P var2);

        public R visitMethodType(MethodType var1, P var2);

        public R visitClassSigType(ClassSigType var1, P var2);

        public R visitClassType(ClassType var1, P var2);

        public R visitTypeParamType(TypeParamType var1, P var2);

        public R visitWildcardType(WildcardType var1, P var2);
    }

    public static class WildcardType
    extends Type {
        public final Kind kind;
        public final Type boundType;

        public WildcardType() {
            this(Kind.UNBOUNDED, null);
        }

        public WildcardType(Kind kind, Type type) {
            this.kind = kind;
            this.boundType = type;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitWildcardType(this, d);
        }

        public String toString() {
            switch (this.kind) {
                case UNBOUNDED: {
                    return "?";
                }
                case EXTENDS: {
                    return "? extends " + this.boundType;
                }
                case SUPER: {
                    return "? super " + this.boundType;
                }
            }
            throw new AssertionError();
        }

        public static enum Kind {
            UNBOUNDED,
            EXTENDS,
            SUPER;

        }
    }
}

