/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JJavaName {
    private static HashSet<String> reservedKeywords;
    private static final Entry[] TABLE;

    public static boolean isJavaIdentifier(String s2) {
        if (s2.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(s2)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s2.length(); ++i) {
            if (Character.isJavaIdentifierPart(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullyQualifiedClassName(String s2) {
        return JJavaName.isJavaPackageName(s2);
    }

    public static boolean isJavaPackageName(String s2) {
        while (s2.length() != 0) {
            int idx = s2.indexOf(46);
            if (idx == -1) {
                idx = s2.length();
            }
            if (!JJavaName.isJavaIdentifier(s2.substring(0, idx))) {
                return false;
            }
            if ((s2 = s2.substring(idx)).length() == 0) continue;
            s2 = s2.substring(1);
        }
        return true;
    }

    public static String getPluralForm(String word) {
        boolean allUpper = true;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (ch >= '\u0080') {
                return word;
            }
            allUpper &= !Character.isLowerCase(ch);
        }
        for (Entry e : TABLE) {
            String r = e.apply(word);
            if (r == null) continue;
            if (allUpper) {
                r = r.toUpperCase();
            }
            return r;
        }
        return word;
    }

    static {
        String[] words;
        reservedKeywords = new HashSet();
        for (String w : words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            reservedKeywords.add(w);
        }
        String[] source = new String[]{"(.*)child", "$1children", "(.+)fe", "$1ves", "(.*)mouse", "$1mise", "(.+)f", "$1ves", "(.+)ch", "$1ches", "(.+)sh", "$1shes", "(.*)tooth", "$1teeth", "(.+)um", "$1a", "(.+)an", "$1en", "(.+)ato", "$1atoes", "(.*)basis", "$1bases", "(.*)axis", "$1axes", "(.+)is", "$1ises", "(.+)ss", "$1sses", "(.+)us", "$1uses", "(.+)s", "$1s", "(.*)foot", "$1feet", "(.+)ix", "$1ixes", "(.+)ex", "$1ices", "(.+)nx", "$1nxes", "(.+)x", "$1xes", "(.+)y", "$1ies", "(.+)", "$1s"};
        TABLE = new Entry[source.length / 2];
        for (int i = 0; i < source.length; i += 2) {
            JJavaName.TABLE[i / 2] = new Entry(source[i], source[i + 1]);
        }
    }

    private static class Entry {
        private final Pattern pattern;
        private final String replacement;

        public Entry(String pattern, String replacement) {
            this.pattern = Pattern.compile(pattern, 2);
            this.replacement = replacement;
        }

        String apply(String word) {
            Matcher m3 = this.pattern.matcher(word);
            if (m3.matches()) {
                StringBuffer buf = new StringBuffer();
                m3.appendReplacement(buf, this.replacement);
                return buf.toString();
            }
            return null;
        }
    }
}

