/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.BoundLocation;

public class ClassBoundCriterion
implements Criterion {
    private final String className;
    public final BoundLocation boundLoc;
    private final Criterion notInMethodCriterion;
    private final Criterion boundLocCriterion;

    public ClassBoundCriterion(String className, BoundLocation boundLoc) {
        this.className = className;
        this.boundLoc = boundLoc;
        this.notInMethodCriterion = Criteria.notInMethod();
        this.boundLocCriterion = Criteria.atBoundLocation(boundLoc);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        return this.boundLocCriterion.isSatisfiedBy(path) && this.notInMethodCriterion.isSatisfiedBy(path);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.CLASS_BOUND;
    }

    public String toString() {
        return "ClassBoundCriterion: for " + this.className + " at " + this.boundLoc;
    }
}

