/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.CastScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class CastCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public CastCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName.substring(0, methodName.lastIndexOf(")") + 1);
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (leaf.getKind() == Tree.Kind.TYPE_CAST) {
            int indexInClass;
            int indexInSource = CastScanner.indexOfCastTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = CastScanner.getMethodCastIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        return b;
    }

    public RelativeLocation getLocation() {
        return this.loc;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.CAST;
    }

    public String toString() {
        return "CastCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

