/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.linear;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import javax.lang.model.element.Element;
import org.checkerframework.checker.linear.LinearAnnotatedTypeFactory;
import org.checkerframework.checker.linear.qual.Unusable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class LinearVisitor
extends BaseTypeVisitor<LinearAnnotatedTypeFactory> {
    public LinearVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    static boolean isLocalVarOrParam(ExpressionTree node) {
        Element elem = TreeUtils.elementFromUse(node);
        if (elem == null) {
            return false;
        }
        switch (elem.getKind()) {
            case PARAMETER: 
            case LOCAL_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    private void checkLegality(ExpressionTree node) {
        if (LinearVisitor.isLocalVarOrParam(node) && ((LinearAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node).hasAnnotation(Unusable.class)) {
            this.checker.report(Result.failure("use.unsafe", TreeUtils.elementFromUse(node), node), node);
        }
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        this.checkLegality(node);
        return super.visitIdentifier(node, p);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        this.checkLegality(node);
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
    }
}

