/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import org.cassandraunit.BaseCassandraUnit;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;

public class CassandraUnit
extends BaseCassandraUnit {
    public Cluster cluster;
    public Keyspace keyspace;
    private DataSet dataSet;
    public static String clusterName;
    public static String host;

    public CassandraUnit(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public CassandraUnit(DataSet dataSet, String configurationFileName) {
        this(dataSet);
        this.configurationFileName = configurationFileName;
    }

    @Override
    protected void load() {
        host = EmbeddedCassandraServerHelper.getHost() + ":" + EmbeddedCassandraServerHelper.getRpcPort();
        clusterName = EmbeddedCassandraServerHelper.getClusterName();
        DataLoader dataLoader = new DataLoader(clusterName, host);
        dataLoader.load(this.dataSet);
        this.cluster = HFactory.getOrCreateCluster((String)clusterName, (String)host);
        this.keyspace = HFactory.createKeyspace((String)this.dataSet.getKeyspace().getName(), (Cluster)this.cluster);
    }
}

